/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.Messages;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.UserType;
import com.floreantpos.report.ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData;

public class SalesSummaryDAO extends _RootDAO {

	public SalesSummaryDAO() {
		super();
	}

	@Override
	protected Class getReferenceClass() {
		return null;
	}

	@Override
	public Serializable save(Object obj) {
		return super.save(obj);
	}

	@Override
	public void saveOrUpdate(Object obj) {
		super.saveOrUpdate(obj);
	}

	public List<ShiftwiseSalesSummaryData> findSalesAnalysis(Date start, Date end, UserType userType, Outlet outlet) {
		Session session = null;

		try {
			ArrayList<ShiftwiseSalesSummaryData> list = new ArrayList<ShiftwiseSalesSummaryData>();

			session = getSession();

			Criteria criteria = session.createCriteria(Shift.class);
			List<Shift> shifts = criteria.list();

			criteria = session.createCriteria(MenuCategory.class);
			List<MenuCategory> categories = criteria.list();

			//			MenuCategory miscCategory = new MenuCategory();
			//			miscCategory.setName(Messages.getString("SalesSummaryDAO.0")); //$NON-NLS-1$
			//			categories.add(miscCategory);

			MenuCategory othersCategory = new MenuCategory();
			othersCategory.setName(Messages.getString("SalesSummaryDAO.3"));
			categories.add(othersCategory);

			//find shift wise salse
			for (Shift shift : shifts) {

				for (MenuCategory category : categories) {

					criteria = session.createCriteria(TicketItem.class, "item"); //$NON-NLS-1$
					criteria.createCriteria("ticket", "t"); //$NON-NLS-1$ //$NON-NLS-2$
					ProjectionList projectionList = Projections.projectionList();
					projectionList.add(Projections.sum(TicketItem.PROP_QUANTITY));
					projectionList.add(Projections.sum(TicketItem.PROP_SUBTOTAL_AMOUNT));
					projectionList.add(Projections.sum(TicketItem.PROP_DISCOUNT_AMOUNT));
					projectionList.add(Projections.sum(TicketItem.PROP_TAX_AMOUNT));
					projectionList.add(Projections.sum(TicketItem.PROP_TOTAL_AMOUNT));
					criteria.setProjection(projectionList);
					doHandleMenuCategorySearch(criteria, category);
					criteria.add(Restrictions.eq("t." + Ticket.PROP_SHIFT_ID, shift.getId())); //$NON-NLS-1$
					criteria.add(Restrictions.ge("t." + Ticket.PROP_ACTIVE_DATE, start)); //$NON-NLS-1$
					criteria.add(Restrictions.le("t." + Ticket.PROP_ACTIVE_DATE, end)); //$NON-NLS-1$

					if (userType != null) {
						criteria.add(Restrictions.eq("t." + Ticket.PROP_OWNER_TYPE_ID, userType.getId())); //$NON-NLS-1$
					}
					if (outlet != null) {
						criteria.add(Restrictions.eq("t." + Ticket.PROP_OUTLET_ID, outlet.getId())); //$NON-NLS-1$
					}
					List datas = criteria.list();
					if (datas.size() > 0) {
						Object[] objects = (Object[]) datas.get(0);

						ShiftwiseSalesSummaryData data = new ShiftwiseSalesSummaryData();
						data.setShiftName(shift.getName());
						data.setCategoryName(category.getName());

						if (objects.length > 0 && objects[0] != null)
							data.setCount(((Number) objects[0]).intValue());

						if (objects.length > 1 && objects[1] != null)
							data.setGross(((Number) objects[1]).doubleValue());

						if (objects.length > 2 && objects[2] != null)
							data.setDiscount(((Number) objects[2]).doubleValue());

						if (objects.length > 3 && objects[3] != null)
							data.setTaxAmount(((Number) objects[3]).doubleValue());

						if (objects.length > 4 && objects[4] != null)
							data.setNetSales(((Number) objects[4]).doubleValue());

						list.add(data);
					}
				}
			}

			//find all sales
			for (MenuCategory category : categories) {

				criteria = session.createCriteria(TicketItem.class, "item"); //$NON-NLS-1$
				criteria.createCriteria("ticket", "t"); //$NON-NLS-1$ //$NON-NLS-2$
				ProjectionList projectionList = Projections.projectionList();
				projectionList.add(Projections.sum(TicketItem.PROP_QUANTITY));
				projectionList.add(Projections.sum(TicketItem.PROP_SUBTOTAL_AMOUNT));
				projectionList.add(Projections.sum(TicketItem.PROP_DISCOUNT_AMOUNT));
				projectionList.add(Projections.sum(TicketItem.PROP_TAX_AMOUNT));
				projectionList.add(Projections.sum(TicketItem.PROP_TOTAL_AMOUNT));
				criteria.setProjection(projectionList);
				doHandleMenuCategorySearch(criteria, category);

				criteria.add(Restrictions.ge("t." + Ticket.PROP_ACTIVE_DATE, start)); //$NON-NLS-1$
				criteria.add(Restrictions.le("t." + Ticket.PROP_ACTIVE_DATE, end)); //$NON-NLS-1$

				if (userType != null) {
					criteria.add(Restrictions.eq("t." + Ticket.PROP_OWNER_TYPE_ID, userType.getId())); //$NON-NLS-1$
				}
				if (outlet != null) {
					criteria.add(Restrictions.eq("t." + Ticket.PROP_OUTLET_ID, outlet.getId())); //$NON-NLS-1$
				}
				List datas = criteria.list();
				if (datas.size() > 0) {
					Object[] objects = (Object[]) datas.get(0);

					ShiftwiseSalesSummaryData data = new ShiftwiseSalesSummaryData();
					data.setShiftName("ALL DAY"); //$NON-NLS-1$
					data.setCategoryName(category.getName());

					if (objects.length > 0 && objects[0] != null)
						data.setCount(((Number) objects[0]).intValue());

					if (objects.length > 1 && objects[1] != null)
						data.setGross(((Number) objects[1]).doubleValue());

					if (objects.length > 2 && objects[2] != null)
						data.setDiscount(((Number) objects[2]).doubleValue());

					if (objects.length > 3 && objects[3] != null)
						data.setTaxAmount(((Number) objects[3]).doubleValue());

					if (objects.length > 4 && objects[4] != null)
						data.setNetSales(((Number) objects[4]).doubleValue());

					list.add(data);
				}
			}
			return list;
		} finally {
			if (session != null) {
				closeSession(session);
			}
		}
	}

	private void doHandleMenuCategorySearch(Criteria criteria, MenuCategory category) {
		if (category.getId() == null) {
			if (category.getName() != null && category.getName().equals(Messages.getString("SalesSummaryDAO.3"))) {
				criteria.add(Restrictions.isNull("item." + TicketItem.PROP_CATEGORY_ID)); //$NON-NLS-1$
			}
			else {
				criteria.add(Restrictions.eq("item." + TicketItem.PROP_CATEGORY_NAME, category.getName())); //$NON-NLS-1$
			}
		}
		else {
			criteria.add(Restrictions.eq("item." + TicketItem.PROP_CATEGORY_ID, category.getId())); //$NON-NLS-1$
		}
	}
}
