/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

public class CardReportModel extends ListTableModel<PosTransaction> {

	//	final String DATE_FORMAT = "MM-dd-yy hh:mm a"; //$NON-NLS-1$

	public CardReportModel(List<PosTransaction> datas) {
		super(new String[] { "ticketId", "paymentType", "cardType", "member", "cardReader", "date", "server", "authCode", "tips", "total", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$
				"transactionType", "customPaymentName", "customPaymentRef", "customPaymentFieldName", "captured", "authorizable", "cardNumber", "cardAuthCode", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
				"cardTransactionID", "cardMarchantGateway", "giftCertNumber", "giftCertFaceValue", "giftCertPaidAmnt", "giftCertCashBackAmnt", "terminalID", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
				"payoutReasonID", "payoutRecepientID", "outletId", "memberId", "tenderAmount" }, datas); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		PosTransaction transaction = getRowData(rowIndex);

		switch (columnIndex) {
			case 0:
				Ticket ticket = transaction.getTicket();
				if (ticket == null) {
					String propTicketId = transaction.getEntityId();
					if (StringUtils.isNotBlank(propTicketId)) {
						return propTicketId;
					}
					return StringUtils.EMPTY;
				}
				return String.valueOf(ticket.getId());

			case 1:
				PaymentType paymentType = transaction.getPaymentType();
				if (paymentType == null) {
					return null;
				}

				String paymentTypeStr;
				if (paymentType.equals(PaymentType.CUSTOM_PAYMENT)) {
					String customPaymentName = transaction.getCustomPaymentName();
					paymentTypeStr = StringUtils.isEmpty(customPaymentName) ? null : customPaymentName;
				}
				else if (paymentType.equals(PaymentType.BANK_ACCOUNT)) {
					String bankAccountDisplayName = transaction.getBankAccountDisplay();
					paymentTypeStr = StringUtils.isEmpty(bankAccountDisplayName) ? null : bankAccountDisplayName;
				}
				else {
					paymentTypeStr = paymentType.getDisplayString();
				}
				if (transaction.getTicket() == null && StringUtils.isNotBlank(transaction.getEntityId())) {
					paymentTypeStr += " (Advance pay)"; //$NON-NLS-1$
				}
				return paymentTypeStr;

			case 2:
				String cardType = transaction.getCardType();

				if (cardType != null) {
					if (cardType.equalsIgnoreCase("CARD")) { //$NON-NLS-1$
						return StringUtils.EMPTY;
					}
					return cardType.replaceAll("_", " "); //$NON-NLS-1$ //$NON-NLS-2$
				}
				else {
					return transaction.getCustomPaymentRefDisplay();
				}

			case 3:
				//				//FIXME:
				//				if (transaction.getCustomerId() != null) {
				//					String customerId = transaction.getCustomerId();
				//					Customer customer = CustomerDAO.getInstance().get(customerId);
				//					if (customer != null) {
				//						return customer.getName();
				//					}
				//
				//					//load customer from pro
				//					return transaction.getCustomerName();
				//				}
				//				return ""; //$NON-NLS-1$
				return transaction.getCustomerName();

			case 4:
				if (transaction instanceof CustomPaymentTransaction) {
					return ((CustomPaymentTransaction) transaction).getCustomPaymentName();
				}
				return transaction.getCardReader() == null ? "" : transaction.getCardReader(); //$NON-NLS-1$

			case 5:
				return DateUtil.formatReportDateWithBrowserTimeOffset(transaction.getTransactionTime());

			case 6:
				String userId = transaction.getUserId();
				if (userId != null) {
					String userName = transaction.getUserName();
					if (userName != null) {
						return userName;
					}
				}
				if (transaction.getTicket() != null) {
					User ticketOwner = transaction.getTicket().getOwner();
					if (ticketOwner != null) {
						return ticketOwner.getFullName();
					}
				}
				return ""; //$NON-NLS-1$

			case 7:
				String cardAuthCode = transaction.getCardAuthCode();
				String customPaymentRef = transaction.getCustomPaymentRef();
				if (cardAuthCode == null) {
					if (StringUtils.isNotBlank(customPaymentRef)) {
						return customPaymentRef;
					}
					return ""; //$NON-NLS-1$
				}
				return cardAuthCode;

			case 8:
				return NumberUtil.formatNumber(transaction.getTipsAmount());

			case 9:
				if (transaction instanceof RefundTransaction) {
					return NumberUtil.formatNumber((-1) * transaction.getAmount());
				}
				return NumberUtil.formatNumber(transaction.getAmount());

			case 10:
				return transaction.getTransactionType();
			case 11:
				if (transaction instanceof CustomPaymentTransaction) {
					return ((CustomPaymentTransaction) transaction).getCustomPaymentName();
				}
				return null;
			case 12:
				if (transaction instanceof CustomPaymentTransaction) {
					return ((CustomPaymentTransaction) transaction).getCustomPaymentRef();
				}
				return null;
			case 13:
				if (transaction instanceof CustomPaymentTransaction) {
					return ((CustomPaymentTransaction) transaction).getCustomPaymentFieldName();
				}
				return null;
			case 14:
				return transaction.isCaptured();
			case 15:
				return transaction.isAuthorizable();
			case 16:
				return transaction.getCardNumber();
			case 17:
				return transaction.getCardAuthCode();
			case 18:
				return transaction.getCardTransactionId();
			case 19:
				return transaction.getCardMerchantGateway();

			case 20:
				return transaction.getGiftCertNumber();
			case 21:
				return transaction.getGiftCertFaceValue();
			case 22:
				return transaction.getGiftCertPaidAmount();
			case 23:
				return transaction.getGiftCertCashBackAmount();
			case 24:
				if (transaction.getOutletId() == null) {
					return "";//$NON-NLS-1$
				}
				Terminal terminal = transaction.getTerminal();
				return terminal == null ? "" : terminal.getId();
			case 25:
				return "";//transaction.getRecepient().getId(); //$NON-NLS-1$
			case 26:
				return "";//transaction.getReason().getId(); //$NON-NLS-1$
			case 27:
				return transaction.getOutletId();
			case 28:
				String customerId = transaction.getCustomerId();
				return StringUtils.isBlank(customerId) ? StringUtils.EMPTY : customerId;
		}

		return null;
	}

}
