package com.floreantpos.model;

/**
 * Enum representing all available template variables for invoice/quotation templates.
 * Each variable has a name (used in Velocity templates) and a description.
 */
public enum TemplateVariable {

	// List/Table Data
	LIST("$list", "data list"),

	// Customer Information
	CUSTOMER_NAME("$customerName", "customer name"), //$NON-NLS-1$
	CUSTOMER_EMAIL("$customerEmail", "customer email"), //$NON-NLS-1$
	CUSTOMER_PHONE("$customerPhone", "customer phone"), //$NON-NLS-1$
	CUSTOMER_ADDRESS("$customerAddress", "customer address"), //$NON-NLS-1$

	// Company Information
	COMPANY_ADDRESS1("$companyAddress1", "company Address 1"), //$NON-NLS-1$
	COMPANY_ADDRESS2("$companyAddress2", "company Address 2"), //$NON-NLS-1$
	COMPANY_ADDRESS3("$companyAddress3", "company Address 3"), //$NON-NLS-1$
	COMPANY_NAME("$companyName", "company Name"), //$NON-NLS-1$
	TELEPHONE("$telephone", "telephone"), //$NON-NLS-1$
	WEB("$web", "web"), //$NON-NLS-1$
	COMPANY_EMAIL("$companyEmail", "company email"); //$NON-NLS-1$

	private final String variableName;
	private final String description;

	TemplateVariable(String variableName, String description) {
		this.variableName = variableName;
		this.description = description;
	}

	public String getVariableName() {
		return variableName;
	}

	public String getDescription() {
		return description;
	}

	/**
	 * Get user-friendly display name (without $ syntax)
	 */
	public String getDisplayName() {
		return variableName.replace("$", "");
	}
}
