package com.floreantpos.model;

public enum RentalStatus {
	// @formatter:off
	OPEN("Open"),
	CLOSED("Closed");
	// @formatter:on

	private final String displayName;

	RentalStatus(String displayName) {
		this.displayName = displayName;
	}

	public static RentalStatus fromString(String name) {
		RentalStatus[] durations = values();
		for (RentalStatus duration : durations) {
			if (duration.name().equalsIgnoreCase(name)) {
				return duration;
			}
		}
		return RentalStatus.OPEN;
	}

	@Override
	public String toString() {
		return displayName;
	}
}