package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the TICKET_ITEM table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="TICKET_ITEM"
 */

public abstract class BaseComboTicketItem extends com.floreantpos.model.TicketItem  implements Comparable, Serializable {

	public static String REF = "ComboTicketItem"; //$NON-NLS-1$
	public static String PROP_SIZE_MODIFIER = "sizeModifier"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseComboTicketItem () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseComboTicketItem (java.lang.String id) {
		super(id);
	}



	private int hashCode = Integer.MIN_VALUE;


	// many to one
	private com.floreantpos.model.TicketItemModifier sizeModifier;

	// collections
	private java.util.List<com.floreantpos.model.TicketItem> comboItems;
	private java.util.List<com.floreantpos.model.TicketItemModifier> ticketItemModifiers;






	/**
	 * Return the value associated with the column: SIZE_MODIFIER_ID
	 */

	public com.floreantpos.model.TicketItemModifier getSizeModifier () {
			return sizeModifier;
	}



	/**
	 * Set the value related to the column: SIZE_MODIFIER_ID
	 * @param sizeModifier the SIZE_MODIFIER_ID value
	 */
			public void setSizeModifier (com.floreantpos.model.TicketItemModifier sizeModifier) {
			this.sizeModifier = sizeModifier;
	}



	/**
	 * Return the value associated with the column: comboItems
	 */

	public java.util.List<com.floreantpos.model.TicketItem> getComboItems () {
			return comboItems;
	}



	/**
	 * Set the value related to the column: comboItems
	 * @param comboItems the comboItems value
	 */
			public void setComboItems (java.util.List<com.floreantpos.model.TicketItem> comboItems) {
			this.comboItems = comboItems;
	}

	public void addTocomboItems (com.floreantpos.model.TicketItem ticketItem) {
		if (null == getComboItems()) setComboItems(new java.util.ArrayList<com.floreantpos.model.TicketItem>());
		getComboItems().add(ticketItem);
	}



	/**
	 * Return the value associated with the column: ticketItemModifiers
	 */

	public java.util.List<com.floreantpos.model.TicketItemModifier> getTicketItemModifiers () {
			return ticketItemModifiers;
	}



	/**
	 * Set the value related to the column: ticketItemModifiers
	 * @param ticketItemModifiers the ticketItemModifiers value
	 */
			public void setTicketItemModifiers (java.util.List<com.floreantpos.model.TicketItemModifier> ticketItemModifiers) {
			this.ticketItemModifiers = ticketItemModifiers;
	}

	public void addToticketItemModifiers (com.floreantpos.model.TicketItemModifier ticketItemModifier) {
		if (null == getTicketItemModifiers()) setTicketItemModifiers(new java.util.ArrayList<com.floreantpos.model.TicketItemModifier>());
		getTicketItemModifiers().add(ticketItemModifier);
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.ComboTicketItem)) return false;
		else {
			com.floreantpos.model.ComboTicketItem comboTicketItem = (com.floreantpos.model.ComboTicketItem) obj;
			if (null == this.getId() || null == comboTicketItem.getId()) return this == obj;
			else return (this.getId().equals(comboTicketItem.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}