/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.Outlet;
import com.floreantpos.model.ProductType;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

public class LabTestReportModel extends ListTableModel<TicketItem> {
	private boolean showQuantityWithItemName = true;
	private boolean jasperModel = true;
	private boolean showCategoryName = false;

	public LabTestReportModel() {
		super(new String[] { "itemName", "qty", "itemSubtotalAmount", "testCategoryName", "productType", "labTestRoomNo", "unit", "itemDiscount", //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$//$NON-NLS-7$//$NON-NLS-8$
				"ItemDiscountName", "sampleId", "productDescription", "qtyDoubleValue", "serialNumber", "warranty", "barcode" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
		Outlet outlet = DataProvider.get().getOutlet();
		showCategoryName = outlet.isShowGroupLabTestByCategory();
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		TicketItem labTestItem = (TicketItem) rows.get(rowIndex);
		ProductType productType = ProductType.fromString(labTestItem.getProductType());
		boolean isRedColor = labTestItem.isVoided() || labTestItem.isReturned();

		switch (columnIndex) {
			case 0:
				//if (StringUtils.isNotBlank(labTestItem.getCategoryName()) || ProductType.match(labTestItem.getProductType(), ProductType.GOODS)) {
				//	return "  " + labTestItem.getNameDisplay(); //$NON-NLS-1$
				//}/
				//else {
				String tagStyle = !jasperModel ? "" : "font-family: SolaimanLipi;";
				if (showQuantityWithItemName) {
					return ReportUtil.createSpan(labTestItem.getNameDisplay(labTestItem.getName(), false, true, true, true), tagStyle, isRedColor);
				}
				return ReportUtil.createSpan(labTestItem.getNameDisplay(labTestItem.getName(), false, true, false), tagStyle, isRedColor);

			case 1:
				return NumberUtil.formatNumberIfNeeded(labTestItem.getQuantity());

			case 2:
				return labTestItem.getSubtotalAmount();
			case 3:
				return StringUtils.isNotBlank(labTestItem.getCategoryName()) ? labTestItem.getCategoryName() : ""; //$NON-NLS-1$
			case 4:
				if (labTestItem.isLabTest() || productType == ProductType.SERVICES || productType == ProductType.SURGICAL_EQUIPMENT) {
					return ""; //$NON-NLS-1$
				}
				if (productType == ProductType.GOODS) {
					if (showCategoryName && StringUtils.isNotBlank(labTestItem.getCategoryName())) {
						return ""; //$NON-NLS-1$
					}
					else {
						return "Consumable products"; //$NON-NLS-1$
					}
				}
				return (productType.getDisplayString());

			case 5:
				return StringUtils.isBlank(labTestItem.getLabTestRoomNo()) ? null : labTestItem.getLabTestRoomNo().trim();

			case 6:
				return ReportUtil.createSpan(labTestItem.getUnitNameDisplay(), isRedColor);

			case 7:
				Double discountAmount = labTestItem.getDiscountAmount();
				if (NumberUtil.isZero(discountAmount)) {
					return null;
				}
				return (-1) * discountAmount;

			case 8:
				List<TicketItemDiscount> discounts = labTestItem.getDiscounts();
				return discounts != null && !discounts.isEmpty() ? discounts.get(0).getName() : StringUtils.EMPTY;

			case 9:
				return StringUtils.isNotBlank(labTestItem.getLabTestId()) ? labTestItem.getLabTestId() : null;

			case 10:
				return StringUtils.isNotBlank(labTestItem.getDescription()) ? labTestItem.getDescription() : StringUtils.EMPTY;

			case 11:
				return labTestItem.getQuantity();

			case 12:
				return labTestItem.getSerialNo();

			case 13:
				return StringUtils.isNotBlank(labTestItem.getWarrantyDurationDisplay()) ? "Warranty " + labTestItem.getWarrantyDurationDisplay() //$NON-NLS-1$
						: StringUtils.EMPTY;
			case 14:
				return labTestItem.getBarcode();

		}
		return null;
	}

	public void setJasperModel(boolean jasperModel) {
		this.jasperModel = jasperModel;
	}

	public void setShowQuantityWithItemName(boolean b) {
		this.showQuantityWithItemName = b;
	}

	public String formatNumber(Double value) {
		return NumberUtil.format(value);
	}

	public int getRowIndexCount() {
		if (super.getRowCount() == 0) {
			return 0;
		}
		return super.getRowCount() - 1;
	}

}
