package com.floreantpos.util;

import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.JsonValue.ValueType;

public class JsonUtil {
	public static String getString(JsonObject jsonObject, String propertyName) {
		if (!jsonObject.containsKey(propertyName)) {
			return null;
		}
		return jsonObject.getString(propertyName);
	}
	
	public static Boolean getBoolean(JsonObject jsonObject, String propertyName) {
		if (!jsonObject.containsKey(propertyName)) {
			return null;
		}
		
		JsonValue jsonValue = jsonObject.get(propertyName);
		ValueType valueType = jsonValue.getValueType();
		switch (valueType) {
			case TRUE:
				return Boolean.TRUE;
				
			case FALSE:
				return Boolean.FALSE;
		}
		return Boolean.valueOf(jsonValue.toString());
	}
	
	public static Integer getInt(JsonObject jsonObject, String propertyName) {
		if (!jsonObject.containsKey(propertyName)) {
			return null;
		}
		
		JsonValue jsonValue = jsonObject.get(propertyName);
		ValueType valueType = jsonValue.getValueType();
		switch (valueType) {
			case NUMBER:
				return ((JsonNumber) jsonValue).intValue();
		}
		return Integer.parseInt(jsonValue.toString());
	}
	
	public static Double getDouble(JsonObject jsonObject, String propertyName) {
		if (!jsonObject.containsKey(propertyName)) {
			return null;
		}
		
		JsonValue jsonValue = jsonObject.get(propertyName);
		ValueType valueType = jsonValue.getValueType();
		switch (valueType) {
			case NUMBER:
				return ((JsonNumber) jsonValue).doubleValue();
		}
		return Double.parseDouble(jsonValue.toString());
	}
	
	
	public static String getStringValue(JsonValue jsonValue) {
		if (jsonValue == JsonValue.NULL || jsonValue == null) {
			return null;
		}
		ValueType valueType = jsonValue.getValueType();
		switch (valueType) {
			case STRING:
				return ((JsonString) jsonValue).getString();

			default:
				break;
		}
		return jsonValue.toString().replaceAll("\"", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public static int getIntValue(JsonValue jsonValue) {
		if (jsonValue == null) {
			return 0;
		}
		ValueType valueType = jsonValue.getValueType();
		switch (valueType) {
			case NUMBER:
				return ((JsonNumber) jsonValue).intValue();

			default:
				break;
		}
		return Integer.parseInt(jsonValue.toString().replaceAll("\"", "")); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public static double getDoubleValue(JsonValue jsonValue) {
		if (jsonValue == null || jsonValue.toString().equals("null")) { //$NON-NLS-1$
			return 0;
		}
		ValueType valueType = jsonValue.getValueType();
		switch (valueType) {
			case NUMBER:
				return ((JsonNumber) jsonValue).doubleValue();

			default:
				break;
		}
		double parseDouble = Double.parseDouble(jsonValue.toString().replaceAll("\"", "")); //$NON-NLS-1$ //$NON-NLS-2$
		return parseDouble;
	}
}
