package com.floreantpos.model;

/**
 * Enum representing all available template variables for invoice/quotation templates.
 * Each variable has a name (used in Velocity templates) and a description.
 */
public enum TemplateVariable {

	// List/Table Data
	LIST("$list", "data list"),

	// Customer Information
	CUSTOMER_NAME("$customerName", "customer name"), //$NON-NLS-1$
	CUSTOMER_EMAIL("$customerEmail", "customer email"), //$NON-NLS-1$
	CUSTOMER_PHONE("$customerPhone", "customer phone"), //$NON-NLS-1$
	CUSTOMER_ADDRESS("$customerAddress", "customer address"), //$NON-NLS-1$

	// Store Information
	ADDRESS_LINE_1("$AddressLine1", "Address line 1"), //$NON-NLS-1$
	ADDRESS_LINE_2("$AddressLine2", "Address line 2"), //$NON-NLS-1$
	ADDRESS_LINE_3("$AddressLine3", " Address line 3"), //$NON-NLS-1$
	STORE_NAME("$storeName", "Store Name"), //$NON-NLS-1$
	TELEPHONE("$telephone", "telephone"), //$NON-NLS-1$
	WEB("$web", "web"), //$NON-NLS-1$
	STORE_EMAIL("$storeEmail", "Store email"), //$NON-NLS-1$
	
	PROPOSAL_DATE("$proposalDate", "Proposal date");

	private final String variableName;
	private final String description;

	TemplateVariable(String variableName, String description) {
		this.variableName = variableName;
		this.description = description;
	}

	public String getVariableName() {
		return variableName;
	}

	public String getDescription() {
		return description;
	}

	/**
	 * Get user-friendly display name (without $ syntax)
	 */
	public String getDisplayName() {
		return variableName.replace("$", "");
	}
}
