package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the MULTIPLIER table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MULTIPLIER"
 */

public abstract class BaseMultiplier  implements Comparable, Serializable {

	public static String REF = "Multiplier"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_GLOBAL_ID = "globalId"; //$NON-NLS-1$
	public static String PROP_MAIN = "main"; //$NON-NLS-1$
	public static String PROP_BUTTON_COLOR = "buttonColor"; //$NON-NLS-1$
	public static String PROP_DEFAULT_MULTIPLIER = "defaultMultiplier"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_TICKET_PREFIX = "ticketPrefix"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_TEXT_COLOR = "textColor"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_RATE = "rate"; //$NON-NLS-1$


	// constructors
	public BaseMultiplier () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseMultiplier (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseMultiplier (
		java.lang.String id,
		java.lang.String globalId) {

		this.setId(id);
		this.setGlobalId(globalId);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String globalId;
				private java.lang.String ticketPrefix;
				private java.lang.Double rate;
				private java.lang.Integer sortOrder;
				private java.lang.Boolean defaultMultiplier;
				private java.lang.Boolean main;
				private java.lang.Integer buttonColor;
				private java.lang.Integer textColor;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="assigned"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: GLOBAL_ID
	 */

	public java.lang.String getGlobalId () {
			return globalId;
	}



	/**
	 * Set the value related to the column: GLOBAL_ID
	 * @param globalId the GLOBAL_ID value
	 */
			public void setGlobalId (java.lang.String globalId) {
			this.globalId = globalId;
	}



	/**
	 * Return the value associated with the column: TICKET_PREFIX
	 */

	public java.lang.String getTicketPrefix () {
			return ticketPrefix;
	}



	/**
	 * Set the value related to the column: TICKET_PREFIX
	 * @param ticketPrefix the TICKET_PREFIX value
	 */
			public void setTicketPrefix (java.lang.String ticketPrefix) {
			this.ticketPrefix = ticketPrefix;
	}



	/**
	 * Return the value associated with the column: RATE
	 */

	public java.lang.Double getRate () {
						return rate == null ? Double.valueOf(0) : rate;
		}



	/**
	 * Set the value related to the column: RATE
	 * @param rate the RATE value
	 */
			public void setRate (java.lang.Double rate) {
			this.rate = rate;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
						return sortOrder == null ? Integer.valueOf(0) : sortOrder;
		}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: DEFAULT_MULTIPLIER
	 */

	public java.lang.Boolean isDefaultMultiplier () {
					return defaultMultiplier == null ? Boolean.FALSE : defaultMultiplier;
		}

	public java.lang.Boolean getDefaultMultiplier () {
				return defaultMultiplier == null ? Boolean.FALSE : defaultMultiplier;
			}


	/**
	 * Set the value related to the column: DEFAULT_MULTIPLIER
	 * @param defaultMultiplier the DEFAULT_MULTIPLIER value
	 */
			public void setDefaultMultiplier (java.lang.Boolean defaultMultiplier) {
			this.defaultMultiplier = defaultMultiplier;
	}



	/**
	 * Return the value associated with the column: MAIN
	 */

	public java.lang.Boolean isMain () {
					return main == null ? Boolean.FALSE : main;
		}

	public java.lang.Boolean getMain () {
				return main == null ? Boolean.FALSE : main;
			}


	/**
	 * Set the value related to the column: MAIN
	 * @param main the MAIN value
	 */
			public void setMain (java.lang.Boolean main) {
			this.main = main;
	}



	/**
	 * Return the value associated with the column: BTN_COLOR
	 */

	public java.lang.Integer getButtonColor () {
						return buttonColor == null ? Integer.valueOf(0) : buttonColor;
		}



	/**
	 * Set the value related to the column: BTN_COLOR
	 * @param buttonColor the BTN_COLOR value
	 */
			public void setButtonColor (java.lang.Integer buttonColor) {
			this.buttonColor = buttonColor;
	}



	/**
	 * Return the value associated with the column: TEXT_COLOR
	 */

	public java.lang.Integer getTextColor () {
						return textColor == null ? Integer.valueOf(0) : textColor;
		}



	/**
	 * Set the value related to the column: TEXT_COLOR
	 * @param textColor the TEXT_COLOR value
	 */
			public void setTextColor (java.lang.Integer textColor) {
			this.textColor = textColor;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Multiplier)) return false;
		else {
			com.floreantpos.model.Multiplier multiplier = (com.floreantpos.model.Multiplier) obj;
			if (null == this.getId() || null == multiplier.getId()) return this == obj;
			else return (this.getId().equals(multiplier.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}