package com.floreantpos.model.dao;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.ScheduledJob;

public class ScheduledJobDAO extends BaseScheduledJobDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public ScheduledJobDAO() {
	}

	public ScheduledJob findByTicketId(String id) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(ScheduledJob.PROP_TICKET_ID, id));
			addDeletedFilter(criteria);
			return (ScheduledJob) criteria.uniqueResult();
		}
	}
}