package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.Consent;
import com.floreantpos.model.InvoiceTemplate;
import com.floreantpos.model.InvoiceTemplateType;
import com.floreantpos.swing.PaginatedListModel;

public class InvoiceTemplateDAO extends BaseInvoiceTemplateDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public InvoiceTemplateDAO () {}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	public void delete(Object obj, Session s) throws HibernateException {
		InvoiceTemplate template = (InvoiceTemplate) obj;
		template.setDeleted(true);
		update(template, s);
	}

	public InvoiceTemplate findInvoiceTemplateByName(String templateName, String outletId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(InvoiceTemplate.class);
			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(InvoiceTemplate.PROP_TEMPLATE_NAME, templateName));
			if (StringUtils.isNotBlank(outletId)) {
				criteria.add(Restrictions.eq(InvoiceTemplate.PROP_OUTLET_ID, outletId));
			}
			List list = criteria.list();
			if (!list.isEmpty()) {

				return (InvoiceTemplate) list.get(0);
			}
		}
		return null;
	}

	public void findAll(InvoiceTemplateType type, String searchTemplate, PaginatedListModel<InvoiceTemplate> dataModel, String outletId) {
		try (Session session = this.createNewSession()) {
			Criteria criteria = session.createCriteria(InvoiceTemplate.class);
			this.addDeletedFilter(criteria);
			if (StringUtils.isNotBlank(outletId)) {
				criteria.add(Restrictions.eq(InvoiceTemplate.PROP_OUTLET_ID, outletId));
			}
			if (StringUtils.isNotBlank(searchTemplate)) {
				criteria.add(Restrictions.ilike(InvoiceTemplate.PROP_TEMPLATE_NAME, searchTemplate, MatchMode.ANYWHERE));
			}
			criteria.add(Restrictions.eq(InvoiceTemplate.PROP_TEMPLATE_TYPE, type.name()).ignoreCase());

			dataModel.setNumRows(rowCount(criteria));

			criteria.setFirstResult(dataModel.getCurrentRowIndex());
			criteria.setMaxResults(dataModel.getPageSize());

			criteria.addOrder(Order.desc(Consent.PROP_CREATE_DATE));
			List<InvoiceTemplate> list = criteria.list();

			dataModel.setData(list);
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
	}

}
