/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.util.DataProvider;

public class UpdateDBTo391 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo391(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void update() throws Exception {
		PosLog.info(getClass(), "Updating " + schemaName + " schema.");

		Map<String, CashDrawer> cashDrawerMap = new HashMap<String, CashDrawer>();

		try (Session session = sessionFactory.openSession()) {

			List<PosTransaction> transactions = findEmptyOutletTransaction(session);
			if (transactions.size() > 0) {

				PosLog.info(getClass(), "Updating " + transactions.size() + " transactions.");

				Transaction tx = session.beginTransaction();

				for (Iterator<PosTransaction> iterator = transactions.iterator(); iterator.hasNext();) {
					PosTransaction transaction = (PosTransaction) iterator.next();

					String cashDrawerId = transaction.getCashDrawerId();

					CashDrawer cashDrawer = cashDrawerMap.get(cashDrawerId);
					if (cashDrawer == null) {
						cashDrawer = (CashDrawer) DataProvider.get().getObjectOf(CashDrawer.class, cashDrawerId);
						cashDrawerMap.put(cashDrawer.getId(), cashDrawer);
					}

					transaction.setOutletId(cashDrawer.getOutletId());
					session.saveOrUpdate(transaction);
				}
				tx.commit();
			}
		}

	}

	private List<PosTransaction> findEmptyOutletTransaction(Session session) {
		Criteria criteria = session.createCriteria(PayOutTransaction.class);
		criteria.add(Restrictions.isNull(PosTransaction.PROP_OUTLET_ID));
		return criteria.list();
	}

}