package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum ReportType {

	//@formatter:off
	TABULAR_REPORT("3 columns tabular"),
	POSITIVE_NEGATIVE("2 columns tabular"),
	PLAIN_REPORT("Plain"), 
	PLAIN_REPORT_SIDE_BY_SIDE("Plain side by side"), 
	//PLAIN_TABULAR_REPORT("Plain with 2 columns table"),
	;
	//@formatter:on

	private final String reportType;

	public String getReportType() {
		return reportType;
	}

	private ReportType(String reportTyp) {
		this.reportType = reportTyp;
	}

	public static ReportType fromString(String name) {
		if (StringUtils.isEmpty(name)) {
			return TABULAR_REPORT;
		}

		ReportType[] values = values();
		for (ReportType reportTypeEnum : values) {
			if (name.equals(reportTypeEnum.name())) {
				return reportTypeEnum;
			}
		}

		return TABULAR_REPORT;
	}

	@Override
	public String toString() {
		return reportType;
	}

}
