package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the GLOBAL_CONFIG table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="GLOBAL_CONFIG"
 */

public abstract class BaseGlobalConfig  implements Comparable, Serializable {

	public static String REF = "GlobalConfig"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_VALUE = "value"; //$NON-NLS-1$
	public static String PROP_LONG_VALUE = "longValue"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_KEY = "key"; //$NON-NLS-1$


	// constructors
	public BaseGlobalConfig () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseGlobalConfig (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String key;
				private java.lang.String value;
				private java.lang.String longValue;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: POS_KEY
	 */

	public java.lang.String getKey () {
			return key;
	}



	/**
	 * Set the value related to the column: POS_KEY
	 * @param key the POS_KEY value
	 */
			public void setKey (java.lang.String key) {
			this.key = key;
	}



	/**
	 * Return the value associated with the column: POS_VALUE
	 */

	public java.lang.String getValue () {
			return value;
	}



	/**
	 * Set the value related to the column: POS_VALUE
	 * @param value the POS_VALUE value
	 */
			public void setValue (java.lang.String value) {
			this.value = value;
	}



	/**
	 * Return the value associated with the column: POS_LONG_VALUE
	 */

	public java.lang.String getLongValue () {
			return longValue;
	}



	/**
	 * Set the value related to the column: POS_LONG_VALUE
	 * @param longValue the POS_LONG_VALUE value
	 */
			public void setLongValue (java.lang.String longValue) {
			this.longValue = longValue;
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.GlobalConfig)) return false;
		else {
			com.floreantpos.model.GlobalConfig globalConfig = (com.floreantpos.model.GlobalConfig) obj;
			if (null == this.getId() || null == globalConfig.getId()) return this == obj;
			else return (this.getId().equals(globalConfig.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}