package com.floreantpos.model.dao;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.Reseller;

public class ResellerDAO extends BaseResellerDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public ResellerDAO() {
	}

	public Reseller findByEmail(String userEmail) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(Reseller.PROP_EMAIL, userEmail));

			List list = criteria.list();
			if (list != null && list.size() > 0) {
				return (Reseller) list.get(0);
			}
			return null;
		}
	}

	public Reseller findById(String resellerId) {
		Session session = null;

		try {
			session = getSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(Reseller.PROP_ID, resellerId));
			return (Reseller) criteria.uniqueResult();
		} finally {
			if (session != null) {
				closeSession(session);
			}
		}
	}

	public boolean isEmailExistExceptCustomer(String email, Reseller customer) {
		if (StringUtils.isEmpty(email)) {
			return false;
		}
		Session session = null;
		try {
			session = createNewSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(Reseller.PROP_EMAIL, email));
			criteria.add(Restrictions.ne(Reseller.PROP_ID, customer.getId()));
			criteria.setProjection(Projections.rowCount());
			Number number = (Number) criteria.uniqueResult();
			return number != null && number.intValue() > 0;

		} finally {
			if (session != null) {
				closeSession(session);
			}
		}
	}

}