package com.floreantpos.model;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseRentalLease;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class RentalLease extends BaseRentalLease implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;
	private transient com.google.gson.JsonObject propertiesContainer;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public RentalLease() {
	}

	/**
	 * Constructor for primary key
	 */
	public RentalLease(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	@Override
	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	@Override
	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	@Override
	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public String getProperties() {
		this.initPropertiesContainer();
		return this.propertiesContainer.toString();
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		this.propertiesContainer = null;
		this.initPropertiesContainer();
	}

	@Override
	public boolean hasProperty(String key) {
		return getProperty(key) != null;
	}

	@Override
	public String getProperty(String key) {
		return this.getProperty(key, null);
	}

	private void initPropertiesContainer() {
		if (this.propertiesContainer == null) {
			String properties = super.getProperties();
			this.propertiesContainer = StringUtils.isBlank(properties) ? new com.google.gson.JsonObject()
					: new Gson().fromJson(properties, com.google.gson.JsonObject.class);
		}
	}

	@Override
	public String getProperty(String key, String defaultValue) {
		this.initPropertiesContainer();
		if (propertiesContainer.has(key)) {
			JsonElement jsonElement = propertiesContainer.get(key);
			if (!jsonElement.isJsonNull()) {
				return jsonElement.getAsString();
			}
		}

		return defaultValue;
	}

	@Override
	public void removeProperty(String propertyName) {
		this.initPropertiesContainer();
		propertiesContainer.remove(propertyName);
		super.setProperties(propertiesContainer.toString());
	}

	public boolean isPropertyValueTrue(String propertyName) {
		String property = getProperty(propertyName);
		return POSUtil.getBoolean(property);
	}

	@Override
	public JsonObject getPropertyStore() {
		return propertiesContainer;
	}

	public void calculatePrice() {
		double subtotalAmount = 0D;
		double totalAmount = 0D;
		double dueAmount = 0D;
		double paidAmount = 0D;
		List<Ticket> invoices = getInvoices();
		if (invoices != null && invoices.size() > 0) {
			for (Ticket ticket : invoices) {
				subtotalAmount += ticket.getSubTotal();
				totalAmount += ticket.getTotalAmount();
				dueAmount += ticket.getDueAmount();
				paidAmount += ticket.getPaidAmount();
			}
		}
		setSubtotalAmount(subtotalAmount);
		setTotalAmount(totalAmount);
		setDueAmount(dueAmount);
		setPaidAmount(paidAmount);
	}
}