package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.Messages;

public enum OrderTypeEnum {

	//@formatter:off
	DINE_IN(Messages.getString("OrderTypeEnum.0")), //$NON-NLS-1$
	TAKE_OUT(Messages.getString("OrderTypeEnum.1")), //$NON-NLS-1$
	BAR_TAB(Messages.getString("OrderTypeEnum.2")),  //$NON-NLS-1$
	RETAIL(Messages.getString("OrderTypeEnum.3")),  //$NON-NLS-1$
	PICK_UP(Messages.getString("OrderTypeEnum.4")),  //$NON-NLS-1$
	DELIVERY(Messages.getString("OrderTypeEnum.5"));  //$NON-NLS-1$
	//@formatter:on

	private final String orderType;

	public String getOrderType() {
		return orderType;
	}

	private OrderTypeEnum(String typeString) {
		this.orderType = typeString;
	}

	public OrderTypeEnum fromString(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}

		return OrderTypeEnum.valueOf(name);
	}

	@Override
	public String toString() {
		return orderType;
	}

}
