package com.floreantpos.report.model;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.ListTableModel;

public class InventoryTransactionReportModel extends ListTableModel {
	SimpleDateFormat dateFormat2 = new SimpleDateFormat("MMM-dd-yy HH:mm "); //$NON-NLS-1$

	DecimalFormat decimalFormat = new DecimalFormat("0.00"); //$NON-NLS-1$
	private double totalAmount;
	private double totalQuantity;
	double totalOnHandValue, amount;
	String type;

	private Double unitCost;
	private Map<String, Double> openingBalanceMap;

	public InventoryTransactionReportModel() {
		super(new String[] { "itemgroup", "items", "sku", "vendor", "tranTime", "tranType", "reasonType", "quantity", "unit", "cost", "total", "location", //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$//$NON-NLS-7$//$NON-NLS-8$//$NON-NLS-9$//$NON-NLS-10$//$NON-NLS-11$//$NON-NLS-12$
				"openningBalance", "itemId" }); //$NON-NLS-1$ //$NON-NLS-2$

	}

	public void setItems(List<InventoryTransaction> transactions, Map openingBalanceMap) {
		this.openingBalanceMap = openingBalanceMap;
		setRows(transactions);
		totalAmount = 0;
		for (InventoryTransaction item : transactions) {
			totalAmount += item.getTotal();
		}
	}

	/*	public void setTotal() {
			if(type.equals("IN")) {
				totalAmount+=totalOnHandValue;
			}
			if(type.equals("Out")) {
				totalAmount-=totalOnHandValue;
			}
		}*/

	public void setQuantity(List<InventoryTransaction> transactions) {
		setRows(transactions);
		totalQuantity = 0;
		for (InventoryTransaction item : transactions) {

			if (item.getType().equals(InventoryTransactionType.IN)) {
				totalQuantity += item.getQuantity();
			}
			else if (item.getType().equals(InventoryTransactionType.OUT)) {
				totalQuantity -= item.getQuantity();
			}
		}
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		InventoryTransaction transactionData = (InventoryTransaction) rows.get(rowIndex);

		MenuItem menuItem = transactionData.getMenuItem();
		switch (columnIndex) {
			case 0:
				MenuGroup menuGroup = menuItem.getParent();
				if (menuGroup == null) {
					return ""; //$NON-NLS-1$
				}
				return menuGroup.getName();

			case 1:
				return menuItem.getDisplayName();

			case 2:
				return menuItem.getSku();

			case 3:
				InventoryVendor vendor = transactionData.getVendor();
				if (vendor == null) {
					return transactionData.getTicketId();
				}
				String vendorName = vendor.getName();
				if (StringUtils.isNotEmpty(vendorName)) {
					return vendorName;
				}
				else {
					return ""; //$NON-NLS-1$
				}

			case 4:
				return dateFormat2.format(transactionData.getTransactionDate());

			case 5:
				return transactionData.getTransactionType().name();

			case 6:
				return transactionData.getReason() == null ? "" : transactionData.getReason().toString(); //$NON-NLS-1$

			case 7:
				totalQuantity = transactionData.getQuantity();
				if (transactionData.getReason() == null) {
					return totalQuantity;
				}
				type = transactionData.getTransactionType().toString();
				if ("OUT".equals(type)) { //$NON-NLS-1$
					return -totalQuantity;
				}
				return totalQuantity;
			case 8:
				return transactionData.getUnitName();

			case 9:
				unitCost = transactionData.getUnitCost();
				return Double.valueOf(unitCost);

			case 10:
//				totalOnHandValue = transactionData.getTotal();
//				if (transactionData.getReason() == null) {
//					return totalOnHandValue;
//				}
//				type = transactionData.getTransactionType().toString();
//				if ("OUT".equals(type)) { //$NON-NLS-1$
//					return -totalOnHandValue;
//				}
//
//				return totalQuantity * unitCost;
				return transactionData.getTotalAmountDisplay();

			case 11:
				if (transactionData.getTransactionType() == null) {
					return ""; //$NON-NLS-1$
				}
				type = transactionData.getTransactionType().toString();
				if ("OUT".equals(type)) { //$NON-NLS-1$
					InventoryLocation fromInventoryLocation = transactionData.getFromInventoryLocation();
					if (fromInventoryLocation != null) {
						return fromInventoryLocation.getName();
					}
				}
				else if ("IN".equals(type)) { //$NON-NLS-1$
					InventoryLocation toInvLoc = transactionData.getToInventoryLocation();
					if (toInvLoc != null) {
						return toInvLoc.getName();
					}
				}

				return ""; //$NON-NLS-1$

			case 12:
				Double double1 = openingBalanceMap.get(menuItem.getId() + "_" + transactionData.getUnit()); //$NON-NLS-1$
				return double1 == null ? 0d : double1;
			case 13:
				return menuItem.getId();

		}
		return null;
	}

	public double getTotalAmount() {
		return totalAmount;
	}

	public double getTotalQuantity() {
		return totalQuantity;
	}

}