package com.floreantpos.model.dao;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.DoctorVisit;
import com.floreantpos.model.DoctorVisitMedicineItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.PaginatedListModel;

public class DoctorVisitMedicineItemDAO extends BaseDoctorVisitMedicineItemDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public DoctorVisitMedicineItemDAO() {
	}

	public void loadMedcation(PaginatedListModel<DoctorVisitMedicineItem> dataModel, String doctorVisitId, String menuItemName) {
		try (Session session = createNewSession()) {

			Criteria criteria = session.createCriteria(DoctorVisitMedicineItem.class);
			addDeletedFilter(criteria);

			if (StringUtils.isNotBlank(doctorVisitId)) {
				DetachedCriteria doctorVisitSubCriteria = DetachedCriteria.forClass(DoctorVisit.class);
				doctorVisitSubCriteria.setProjection(Property.forName(DoctorVisit.PROP_ID));
				doctorVisitSubCriteria.add(Restrictions.eq(DoctorVisit.PROP_ID, doctorVisitId));
				criteria.add(Property.forName(DoctorVisitMedicineItem.PROP_DOCTOR_VISIT).in(doctorVisitSubCriteria)); //$NON-NLS-1$
			}
			
			if (StringUtils.isNotBlank(menuItemName)) {
				DetachedCriteria menuItemNameSubCriteria = DetachedCriteria.forClass(MenuItem.class);
				menuItemNameSubCriteria.setProjection(Property.forName(MenuItem.PROP_ID));
				
				Disjunction disjunction = Restrictions.disjunction();
				disjunction.add(Restrictions.eq(MenuItem.PROP_BARCODE, menuItemName));
				disjunction.add(Restrictions.eq(MenuItem.PROP_SKU, menuItemName));
				disjunction.add(Restrictions.ilike(MenuItem.PROP_NAME, menuItemName, MatchMode.ANYWHERE));
				menuItemNameSubCriteria.add(disjunction);
				
				criteria.add(Property.forName(DoctorVisitMedicineItem.PROP_ITEM_ID).in(menuItemNameSubCriteria)); //$NON-NLS-1$
			}

			dataModel.setNumRows(rowCount(criteria));
			criteria.setFirstResult(dataModel.getCurrentRowIndex());
			criteria.setMaxResults(dataModel.getPageSize());
			dataModel.setData(criteria.list());
		}
	}

}