package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the VOID_ITEM table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="VOID_ITEM"
 */

public abstract class BaseVoidItem  implements Comparable, Serializable {

	public static String REF = "VoidItem"; //$NON-NLS-1$
	public static String PROP_VOID_DATE = "voidDate"; //$NON-NLS-1$
	public static String PROP_QUANTITY = "quantity"; //$NON-NLS-1$
	public static String PROP_ITEM_WASTED = "itemWasted"; //$NON-NLS-1$
	public static String PROP_PRINTER_GROUP_ID = "printerGroupId"; //$NON-NLS-1$
	public static String PROP_VOID_BY_USER_ID = "voidByUserId"; //$NON-NLS-1$
	public static String PROP_UNIT_PRICE = "unitPrice"; //$NON-NLS-1$
	public static String PROP_TICKET_ID = "ticketId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_VOID_REASON = "voidReason"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_CASH_DRAWER_ID = "cashDrawerId"; //$NON-NLS-1$
	public static String PROP_TOTAL_PRICE = "totalPrice"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_NAME = "menuItemName"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_ID = "menuItemId"; //$NON-NLS-1$
	public static String PROP_TERMINAL_ID = "terminalId"; //$NON-NLS-1$
	public static String PROP_MODIFIER = "modifier"; //$NON-NLS-1$
	public static String PROP_MODIFIER_ID = "modifierId"; //$NON-NLS-1$


	// constructors
	public BaseVoidItem () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseVoidItem (
		java.lang.String id,
		java.lang.String outletId) {

		this.setId(id);
		this.setOutletId(outletId);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key

	private java.lang.String id;

	private java.lang.String outletId;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String menuItemName;
				private java.lang.String menuItemId;
				private java.lang.String modifierId;
				private java.lang.Double quantity;
				private java.lang.String voidReason;
				private java.util.Date voidDate;
				private java.lang.Double unitPrice;
				private java.lang.Double totalPrice;
				private java.lang.Boolean itemWasted;
				private java.lang.Boolean modifier;
				private java.lang.String ticketId;
				private java.lang.String cashDrawerId;
				private java.lang.Integer terminalId;
				private java.lang.String voidByUserId;
				private java.lang.String printerGroupId;
	


	/**
     * @hibernate.property
     *  column=ID
	 * not-null=true
	 */
	public java.lang.String getId () {
		return this.id;
	}

	/**
	 * Set the value related to the column: ID
	 * @param id the ID value
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}

	/**
     * @hibernate.property
     *  column=OUTLET_ID
	 * not-null=true
	 */
	public java.lang.String getOutletId () {
		return this.outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId (java.lang.String outletId) {
		this.outletId = outletId;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: MENU_ITEM_NAME
	 */

	public java.lang.String getMenuItemName () {
			return menuItemName;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_NAME
	 * @param menuItemName the MENU_ITEM_NAME value
	 */
			public void setMenuItemName (java.lang.String menuItemName) {
			this.menuItemName = menuItemName;
	}



	/**
	 * Return the value associated with the column: MENU_ITEM_ID
	 */

	public java.lang.String getMenuItemId () {
			return menuItemId;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_ID
	 * @param menuItemId the MENU_ITEM_ID value
	 */
			public void setMenuItemId (java.lang.String menuItemId) {
			this.menuItemId = menuItemId;
	}



	/**
	 * Return the value associated with the column: MODIFIER_ID
	 */

	public java.lang.String getModifierId () {
			return modifierId;
	}



	/**
	 * Set the value related to the column: MODIFIER_ID
	 * @param modifierId the MODIFIER_ID value
	 */
			public void setModifierId (java.lang.String modifierId) {
			this.modifierId = modifierId;
	}



	/**
	 * Return the value associated with the column: QUANTITY
	 */

	public java.lang.Double getQuantity () {
						return quantity == null ? Double.valueOf(0) : quantity;
		}



	/**
	 * Set the value related to the column: QUANTITY
	 * @param quantity the QUANTITY value
	 */
			public void setQuantity (java.lang.Double quantity) {
			this.quantity = quantity;
	}



	/**
	 * Return the value associated with the column: VOID_REASON
	 */

	public java.lang.String getVoidReason () {
			return voidReason;
	}



	/**
	 * Set the value related to the column: VOID_REASON
	 * @param voidReason the VOID_REASON value
	 */
			public void setVoidReason (java.lang.String voidReason) {
			this.voidReason = voidReason;
	}



	/**
	 * Return the value associated with the column: VOID_DATE
	 */

	public java.util.Date getVoidDate () {
			return voidDate;
	}



	/**
	 * Set the value related to the column: VOID_DATE
	 * @param voidDate the VOID_DATE value
	 */
			public void setVoidDate (java.util.Date voidDate) {
			this.voidDate = voidDate;
	}



	/**
	 * Return the value associated with the column: UNIT_PRICE
	 */

	public java.lang.Double getUnitPrice () {
						return unitPrice == null ? Double.valueOf(0) : unitPrice;
		}



	/**
	 * Set the value related to the column: UNIT_PRICE
	 * @param unitPrice the UNIT_PRICE value
	 */
			public void setUnitPrice (java.lang.Double unitPrice) {
			this.unitPrice = unitPrice;
	}



	/**
	 * Return the value associated with the column: TOTAL_PRICE
	 */

	public java.lang.Double getTotalPrice () {
						return totalPrice == null ? Double.valueOf(0) : totalPrice;
		}



	/**
	 * Set the value related to the column: TOTAL_PRICE
	 * @param totalPrice the TOTAL_PRICE value
	 */
			public void setTotalPrice (java.lang.Double totalPrice) {
			this.totalPrice = totalPrice;
	}



	/**
	 * Return the value associated with the column: ITEM_WASTED
	 */

	public java.lang.Boolean isItemWasted () {
					return itemWasted == null ? Boolean.FALSE : itemWasted;
		}

	public java.lang.Boolean getItemWasted () {
				return itemWasted == null ? Boolean.FALSE : itemWasted;
			}


	/**
	 * Set the value related to the column: ITEM_WASTED
	 * @param itemWasted the ITEM_WASTED value
	 */
			public void setItemWasted (java.lang.Boolean itemWasted) {
			this.itemWasted = itemWasted;
	}



	/**
	 * Return the value associated with the column: MODIFIER
	 */

	public java.lang.Boolean isModifier () {
					return modifier == null ? Boolean.FALSE : modifier;
		}

	public java.lang.Boolean getModifier () {
				return modifier == null ? Boolean.FALSE : modifier;
			}


	/**
	 * Set the value related to the column: MODIFIER
	 * @param modifier the MODIFIER value
	 */
			public void setModifier (java.lang.Boolean modifier) {
			this.modifier = modifier;
	}



	/**
	 * Return the value associated with the column: TICKET_ID
	 */

	public java.lang.String getTicketId () {
			return ticketId;
	}



	/**
	 * Set the value related to the column: TICKET_ID
	 * @param ticketId the TICKET_ID value
	 */
			public void setTicketId (java.lang.String ticketId) {
			this.ticketId = ticketId;
	}



	/**
	 * Return the value associated with the column: CASH_DRAWER_ID
	 */

	public java.lang.String getCashDrawerId () {
			return cashDrawerId;
	}



	/**
	 * Set the value related to the column: CASH_DRAWER_ID
	 * @param cashDrawerId the CASH_DRAWER_ID value
	 */
			public void setCashDrawerId (java.lang.String cashDrawerId) {
			this.cashDrawerId = cashDrawerId;
	}



	/**
	 * Return the value associated with the column: TERMINAL_ID
	 */

	public java.lang.Integer getTerminalId () {
						return terminalId == null ? Integer.valueOf(0) : terminalId;
		}



	/**
	 * Set the value related to the column: TERMINAL_ID
	 * @param terminalId the TERMINAL_ID value
	 */
			public void setTerminalId (java.lang.Integer terminalId) {
			this.terminalId = terminalId;
	}



	/**
	 * Return the value associated with the column: VOID_BY_USER_ID
	 */

	public java.lang.String getVoidByUserId () {
			return voidByUserId;
	}



	/**
	 * Set the value related to the column: VOID_BY_USER_ID
	 * @param voidByUserId the VOID_BY_USER_ID value
	 */
			public void setVoidByUserId (java.lang.String voidByUserId) {
			this.voidByUserId = voidByUserId;
	}



	/**
	 * Return the value associated with the column: PG_ID
	 */

	public java.lang.String getPrinterGroupId () {
			return printerGroupId;
	}



	/**
	 * Set the value related to the column: PG_ID
	 * @param printerGroupId the PG_ID value
	 */
			public void setPrinterGroupId (java.lang.String printerGroupId) {
			this.printerGroupId = printerGroupId;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;//abcd
		if (!(obj instanceof com.floreantpos.model.VoidItem)) return false;
		else {
			com.floreantpos.model.VoidItem voidItem = (com.floreantpos.model.VoidItem) obj;
			if (null != this.getId() && null != voidItem.getId()) {
				if (!this.getId().equals(voidItem.getId())) {
					return false;
				}
			}
			else {
				return false;
			}
			if (null != this.getOutletId() && null != voidItem.getOutletId()) {
				if (!this.getOutletId().equals(voidItem.getOutletId())) {
					return false;
				}
			}
			else {
				return false;
			}
			return true;
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			StringBuilder sb = new StringBuilder();
			if (null != this.getId()) {
				sb.append(this.getId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			if (null != this.getOutletId()) {
				sb.append(this.getOutletId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			this.hashCode = sb.toString().hashCode();
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}