package com.floreantpos.payment.common;

import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Project;

public interface Payable {
	String getEntityId();
	
	Project getProject();
	
	public void setProject(Project project);

	double getSubTotal();

	Double getDueValue();

	void setDueValue(double d);

	PosTransaction createTransaction();

	default PosTransaction createTransaction(PaymentType paymentType) {
		return paymentType.createTransaction();
	}

	default String getCustomerId() {
		return null;
	};

	default void setCustomerId(String customerId) {
	}
}
