package com.floreantpos.model;

public enum ReportFrequency {
	//@formatter:off
	EVERY("EVERY","Every"), //$NON-NLS-1$
	DAILY("DAILY", "Daily report of current day"), //$NON-NLS-1$
	DAILY_PREVIOUS_DAY_REPORT("DAILY_REPORT_OF_LAST_WORKING_DAY", "Daily report of last working day"), //$NON-NLS-1$
	WEEKLY("WEEKLY", "Weekly"), //$NON-NLS-1$
	MONTHLY("MONTHLY", "Monthly") //$NON-NLS-1$
	;
	//@formatter:on

	private final String key;
	private final String name;

	ReportFrequency(String key, String name) {
		this.key = key;
		this.name = name;
	}

	public String getKey() {
		return key;
	}

	public String getDisplayString() {
		return name;
	}

	@Override
	public String toString() {
		return name;
	}

	//	public static ReportFrequency fromDisplayString(String value) {
	//		for (ReportFrequency frequency : ReportFrequency.values()) {
	//			if (frequency.getDisplayString().equals(value)) {
	//				return frequency;
	//			}
	//		}
	//		return null;
	//	}

	public static ReportFrequency fromKey(String key) {
		for (ReportFrequency frequency : ReportFrequency.values()) {
			if (frequency.getKey().equals(key)) {
				return frequency;
			}
		}
		return null;
	}
}
