package com.floreantpos.swing;

import java.util.List;

import com.floreantpos.Messages;

public interface PaginationSupport {
	public int getNumRows();

	public void setNumRows(int numRows);

	public int getCurrentRowIndex();

	public void setCurrentRowIndex(int currentRowIndex);

	public int getPageSize();

	public void setPageSize(int pageSize);

	public boolean hasNext();

	public boolean hasPrevious();

	public int getNextRowIndex();

	public int getPreviousRowIndex();

	public void setRows(List rows);

	public default String getDisplayText() {
		int startNumber = getCurrentRowIndex() + 1;
		int endNumber = getNextRowIndex();
		int totalNumber = getNumRows();
		if (endNumber > totalNumber) {
			endNumber = totalNumber;
		}
		if(totalNumber < startNumber) {
			startNumber = 1;
		}
		return String.format(Messages.getString("PaginationSupport.1"), startNumber, endNumber, totalNumber); //$NON-NLS-1$
	}
}
