package com.floreantpos.model;

import org.apache.commons.lang3.StringUtils;

public enum MedicationStatus {
	//@formatter:off
	PENDING("Pending", 0), 
	CANCELLED("Cancelled", 1), 
	COMPLETED("Completed", 2),
	RESCHEDULED("Rescheduled", 3),
	ON_HOLD("On hold", 4)
	;
	//@formatter:on
	private String displayString;
	private int index;

	private MedicationStatus(String displayString, int index) {
		this.displayString = displayString;
		this.index = index;
	}

	public int getIndex() {
		return index;
	}

	public String getDisplayString() {
		return displayString;
	}

	@Override
	public String toString() {
		return getDisplayString();
	}

	public static MedicationStatus fromName(String name) {
		if (StringUtils.isNotBlank(name)) {

			for (MedicationStatus status : values()) {
				if (status.name().equals(name)) {
					return status;
				}
			}
		}
		return MedicationStatus.PENDING;
	}

}