package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum BedType {
	//@formatter:off
		NORMAL("Normal"),
		OT("OT")
		;
		//@formatter:on
	private String displayString;

	private BedType(String displayString) {
		this.displayString = displayString;
	}

	public static BedType fromString(String s) {
		if (StringUtils.isBlank(s)) {
			return NORMAL;
		}

		try {
			BedType filter = valueOf(s.toUpperCase());
			return filter;
		} catch (Exception e) {
			return NORMAL;
		}
	}

	public String getDisplayString() {
		return displayString;
	}

	@Override
	public String toString() {
		return getDisplayString();
	}

	public static boolean match(String src, BedType target) {
		BedType bedType = BedType.fromString(src);
		return target == bedType;
	}
}
