package com.floreantpos.model.base;

import java.io.Serializable;


/**
 * This is an object that contains data related to the MED_BLOOD_INVENTORY_TRANSACTION table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MED_BLOOD_INVENTORY_TRANSACTION"
 */

public abstract class BaseBloodInventoryTransaction  implements Comparable, Serializable {

	public static String REF = "BloodInventoryTransaction"; //$NON-NLS-1$
	public static String PROP_MRP_PRICE = "mrpPrice"; //$NON-NLS-1$
	public static String PROP_BLOOD_GROUP = "bloodGroup"; //$NON-NLS-1$
	public static String PROP_VENDOR_ID = "vendorId"; //$NON-NLS-1$
	public static String PROP_BAG_NUMBER = "bagNumber"; //$NON-NLS-1$
	public static String PROP_FROM_LOCATION_ID = "fromLocationId"; //$NON-NLS-1$
	public static String PROP_TO_LOCATION_ID = "toLocationId"; //$NON-NLS-1$
	public static String PROP_TO_OULTET_ID = "toOultetId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_UNIT = "unit"; //$NON-NLS-1$
	public static String PROP_CREATE_DATE = "createDate"; //$NON-NLS-1$
	public static String PROP_COST = "cost"; //$NON-NLS-1$
	public static String PROP_REMARK = "remark"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_PATIENT_ID = "patientId"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_TRANSACTION_DATE = "transactionDate"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_INVENTORY_TYPE = "inventoryType"; //$NON-NLS-1$
	public static String PROP_QUANTITY = "quantity"; //$NON-NLS-1$
	public static String PROP_BLOOD_ISSUED = "bloodIssued"; //$NON-NLS-1$
	public static String PROP_TYPE = "type"; //$NON-NLS-1$
	public static String PROP_TICKET_ID = "ticketId"; //$NON-NLS-1$
	public static String PROP_VOLUME = "volume"; //$NON-NLS-1$
	public static String PROP_PRICE = "price"; //$NON-NLS-1$
	public static String PROP_USER_ID = "userId"; //$NON-NLS-1$
	public static String PROP_TOTAL = "total"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_BLOOD_TYPE = "bloodType"; //$NON-NLS-1$
	public static String PROP_REFERENCE_NO = "referenceNo"; //$NON-NLS-1$


	// constructors
	public BaseBloodInventoryTransaction () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseBloodInventoryTransaction (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date createDate;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
				private java.util.Date transactionDate;
				private java.lang.String inventoryType;
				private java.lang.String vendorId;
				private java.lang.String patientId;
				private java.lang.String bloodGroup;
				private java.lang.String bloodType;
				private java.lang.Integer quantity;
				private java.lang.String unit;
				private java.lang.Double volume;
				private java.lang.String bagNumber;
				private java.lang.Boolean bloodIssued;
				private java.lang.Double price;
				private java.lang.Double mrpPrice;
				private java.lang.Double cost;
				private java.lang.Double total;
				private java.lang.String referenceNo;
				private java.lang.String remark;
				private java.lang.String outletId;
				private java.lang.String fromLocationId;
				private java.lang.String toOultetId;
				private java.lang.String toLocationId;
				private java.lang.String userId;
				private java.lang.Integer type;
				private java.lang.String ticketId;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: CREATE_DATE
	 */

	public java.util.Date getCreateDate () {
			return createDate;
	}



	/**
	 * Set the value related to the column: CREATE_DATE
	 * @param createDate the CREATE_DATE value
	 */
			public void setCreateDate (java.util.Date createDate) {
			this.createDate = createDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: TRANSACTION_DATE
	 */

	public java.util.Date getTransactionDate () {
			return transactionDate;
	}



	/**
	 * Set the value related to the column: TRANSACTION_DATE
	 * @param transactionDate the TRANSACTION_DATE value
	 */
			public void setTransactionDate (java.util.Date transactionDate) {
			this.transactionDate = transactionDate;
	}



	/**
	 * Return the value associated with the column: INVENTORY_TYPE
	 */

	public java.lang.String getInventoryType () {
			return inventoryType;
	}



	/**
	 * Set the value related to the column: INVENTORY_TYPE
	 * @param inventoryType the INVENTORY_TYPE value
	 */
			public void setInventoryType (java.lang.String inventoryType) {
			this.inventoryType = inventoryType;
	}



	/**
	 * Return the value associated with the column: VENDOR_ID
	 */

	public java.lang.String getVendorId () {
			return vendorId;
	}



	/**
	 * Set the value related to the column: VENDOR_ID
	 * @param vendorId the VENDOR_ID value
	 */
			public void setVendorId (java.lang.String vendorId) {
			this.vendorId = vendorId;
	}



	/**
	 * Return the value associated with the column: PATIENT_ID
	 */

	public java.lang.String getPatientId () {
			return patientId;
	}



	/**
	 * Set the value related to the column: PATIENT_ID
	 * @param patientId the PATIENT_ID value
	 */
			public void setPatientId (java.lang.String patientId) {
			this.patientId = patientId;
	}



	/**
	 * Return the value associated with the column: BLOOD_GROUP
	 */

	public java.lang.String getBloodGroup () {
			return bloodGroup;
	}



	/**
	 * Set the value related to the column: BLOOD_GROUP
	 * @param bloodGroup the BLOOD_GROUP value
	 */
			public void setBloodGroup (java.lang.String bloodGroup) {
			this.bloodGroup = bloodGroup;
	}



	/**
	 * Return the value associated with the column: BLOOD_TYPE
	 */

	public java.lang.String getBloodType () {
			return bloodType;
	}



	/**
	 * Set the value related to the column: BLOOD_TYPE
	 * @param bloodType the BLOOD_TYPE value
	 */
			public void setBloodType (java.lang.String bloodType) {
			this.bloodType = bloodType;
	}



	/**
	 * Return the value associated with the column: QUANTITY
	 */

	public java.lang.Integer getQuantity () {
						return quantity == null ? Integer.valueOf(0) : quantity;
		}



	/**
	 * Set the value related to the column: QUANTITY
	 * @param quantity the QUANTITY value
	 */
			public void setQuantity (java.lang.Integer quantity) {
			this.quantity = quantity;
	}



	/**
	 * Return the value associated with the column: UNIT
	 */

	public java.lang.String getUnit () {
			return unit;
	}



	/**
	 * Set the value related to the column: UNIT
	 * @param unit the UNIT value
	 */
			public void setUnit (java.lang.String unit) {
			this.unit = unit;
	}



	/**
	 * Return the value associated with the column: VOLUME
	 */

	public java.lang.Double getVolume () {
						return volume == null ? Double.valueOf(0) : volume;
		}



	/**
	 * Set the value related to the column: VOLUME
	 * @param volume the VOLUME value
	 */
			public void setVolume (java.lang.Double volume) {
			this.volume = volume;
	}



	/**
	 * Return the value associated with the column: BAG_NUMBER
	 */

	public java.lang.String getBagNumber () {
			return bagNumber;
	}



	/**
	 * Set the value related to the column: BAG_NUMBER
	 * @param bagNumber the BAG_NUMBER value
	 */
			public void setBagNumber (java.lang.String bagNumber) {
			this.bagNumber = bagNumber;
	}



	/**
	 * Return the value associated with the column: BLOOD_ISSUED
	 */

	public java.lang.Boolean isBloodIssued () {
						return bloodIssued == null ? Boolean.valueOf(false) : bloodIssued;
			}

	public java.lang.Boolean getBloodIssued () {
					return bloodIssued == null ? Boolean.valueOf(false) : bloodIssued;
			}


	/**
	 * Set the value related to the column: BLOOD_ISSUED
	 * @param bloodIssued the BLOOD_ISSUED value
	 */
			public void setBloodIssued (java.lang.Boolean bloodIssued) {
			this.bloodIssued = bloodIssued;
	}


	/**
	 * Custom property
	 */
	public static String getBloodIssuedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: PRICE
	 */

	public java.lang.Double getPrice () {
						return price == null ? Double.valueOf(0) : price;
		}



	/**
	 * Set the value related to the column: PRICE
	 * @param price the PRICE value
	 */
			public void setPrice (java.lang.Double price) {
			this.price = price;
	}



	/**
	 * Return the value associated with the column: MRP_PRICE
	 */

	public java.lang.Double getMrpPrice () {
						return mrpPrice == null ? Double.valueOf(0) : mrpPrice;
		}



	/**
	 * Set the value related to the column: MRP_PRICE
	 * @param mrpPrice the MRP_PRICE value
	 */
			public void setMrpPrice (java.lang.Double mrpPrice) {
			this.mrpPrice = mrpPrice;
	}



	/**
	 * Return the value associated with the column: COST
	 */

	public java.lang.Double getCost () {
						return cost == null ? Double.valueOf(0) : cost;
		}



	/**
	 * Set the value related to the column: COST
	 * @param cost the COST value
	 */
			public void setCost (java.lang.Double cost) {
			this.cost = cost;
	}



	/**
	 * Return the value associated with the column: TOTAL
	 */

	public java.lang.Double getTotal () {
						return total == null ? Double.valueOf(0) : total;
		}



	/**
	 * Set the value related to the column: TOTAL
	 * @param total the TOTAL value
	 */
			public void setTotal (java.lang.Double total) {
			this.total = total;
	}



	/**
	 * Return the value associated with the column: REF_NO
	 */

	public java.lang.String getReferenceNo () {
			return referenceNo;
	}



	/**
	 * Set the value related to the column: REF_NO
	 * @param referenceNo the REF_NO value
	 */
			public void setReferenceNo (java.lang.String referenceNo) {
			this.referenceNo = referenceNo;
	}



	/**
	 * Return the value associated with the column: REMARK
	 */

	public java.lang.String getRemark () {
			return remark;
	}



	/**
	 * Set the value related to the column: REMARK
	 * @param remark the REMARK value
	 */
			public void setRemark (java.lang.String remark) {
			this.remark = remark;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: FROM_INVENTORY_LOCATION
	 */

	public java.lang.String getFromLocationId () {
			return fromLocationId;
	}



	/**
	 * Set the value related to the column: FROM_INVENTORY_LOCATION
	 * @param fromLocationId the FROM_INVENTORY_LOCATION value
	 */
			public void setFromLocationId (java.lang.String fromLocationId) {
			this.fromLocationId = fromLocationId;
	}



	/**
	 * Return the value associated with the column: TO_OUTLET
	 */

	public java.lang.String getToOultetId () {
			return toOultetId;
	}



	/**
	 * Set the value related to the column: TO_OUTLET
	 * @param toOultetId the TO_OUTLET value
	 */
			public void setToOultetId (java.lang.String toOultetId) {
			this.toOultetId = toOultetId;
	}



	/**
	 * Return the value associated with the column: TO_INVENTORY_LOCATION
	 */

	public java.lang.String getToLocationId () {
			return toLocationId;
	}



	/**
	 * Set the value related to the column: TO_INVENTORY_LOCATION
	 * @param toLocationId the TO_INVENTORY_LOCATION value
	 */
			public void setToLocationId (java.lang.String toLocationId) {
			this.toLocationId = toLocationId;
	}


	/**
	 * Return the value associated with the column: USER_ID
	 */

	public java.lang.String getUserId () {
			return userId;
	}



	/**
	 * Set the value related to the column: USER_ID
	 * @param userId the USER_ID value
	 */
			public void setUserId (java.lang.String userId) {
			this.userId = userId;
	}



	/**
	 * Return the value associated with the column: TRAN_TYPE
	 */

	public java.lang.Integer getType () {
						return type == null ? Integer.valueOf(0) : type;
		}



	/**
	 * Set the value related to the column: TRAN_TYPE
	 * @param type the TRAN_TYPE value
	 */
			public void setType (java.lang.Integer type) {
			this.type = type;
	}



	/**
	 * Return the value associated with the column: ticket_id
	 */

	public java.lang.String getTicketId () {
			return ticketId;
	}



	/**
	 * Set the value related to the column: ticket_id
	 * @param ticketId the ticket_id value
	 */
			public void setTicketId (java.lang.String ticketId) {
			this.ticketId = ticketId;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.BloodInventoryTransaction)) return false;
		else {
			com.floreantpos.model.BloodInventoryTransaction bloodInventoryTransaction = (com.floreantpos.model.BloodInventoryTransaction) obj;
			if (null == this.getId() || null == bloodInventoryTransaction.getId()) return this == obj;
			else return (this.getId().equals(bloodInventoryTransaction.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}