package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the LEASE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="LEASE"
 */

public abstract class BaseRentalLease  implements Comparable, Serializable {

	public static String REF = "RentalLease"; //$NON-NLS-1$
	public static String PROP_ADVANCE_AMOUNT = "advanceAmount"; //$NON-NLS-1$
	public static String PROP_SUBTOTAL_AMOUNT = "subtotalAmount"; //$NON-NLS-1$
	public static String PROP_REFUNDABLE_AMOUNT = "refundableAmount"; //$NON-NLS-1$
	public static String PROP_DUE_AMOUNT = "dueAmount"; //$NON-NLS-1$
	public static String PROP_BILLING_CYCLE_DURATION = "billingCycleDuration"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_NEXT_BILLING_DATE = "nextBillingDate"; //$NON-NLS-1$
	public static String PROP_TAX_AMOUNT = "taxAmount"; //$NON-NLS-1$
	public static String PROP_RECURRING = "recurring"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_VOIDED = "voided"; //$NON-NLS-1$
	public static String PROP_FEE_AMOUNT = "feeAmount"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_REFUND_AMOUNT = "refundAmount"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_ID = "customerId"; //$NON-NLS-1$
	public static String PROP_RENTAL_ITEM_ID = "rentalItemId"; //$NON-NLS-1$
	public static String PROP_TOTAL_AMOUNT = "totalAmount"; //$NON-NLS-1$
	public static String PROP_VOID_AMOUNT = "voidAmount"; //$NON-NLS-1$
	public static String PROP_DISCOUNT_AMOUNT = "discountAmount"; //$NON-NLS-1$
	public static String PROP_PAID_AMOUNT = "paidAmount"; //$NON-NLS-1$
	public static String PROP_BILLING_CYCLE_DURATION_TYPE = "billingCycleDurationType"; //$NON-NLS-1$
	public static String PROP_ROUNDED_AMOUNT = "roundedAmount"; //$NON-NLS-1$
	public static String PROP_CLOSED = "closed"; //$NON-NLS-1$
	public static String PROP_USER_ID = "userId"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_FROM_DATE = "fromDate"; //$NON-NLS-1$
	public static String PROP_TO_DATE = "toDate"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseRentalLease () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseRentalLease (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date fromDate;
				private java.util.Date toDate;
				private java.util.Date createdDate;
				private java.util.Date nextBillingDate;
				private java.lang.Integer billingCycleDuration;
				private java.lang.String billingCycleDurationType;
				private java.lang.Boolean recurring;
				private java.lang.String customerId;
				private java.lang.String rentalItemId;
				private java.lang.String status;
				private java.lang.Double subtotalAmount;
				private java.lang.Double discountAmount;
				private java.lang.Double taxAmount;
				private java.lang.Double totalAmount;
				private java.lang.Double paidAmount;
				private java.lang.Double voidAmount;
				private java.lang.Double refundAmount;
				private java.lang.Double refundableAmount;
				private java.lang.Double dueAmount;
				private java.lang.Double feeAmount;
				private java.lang.Double advanceAmount;
				private java.lang.Double roundedAmount;
				private java.lang.Boolean voided;
				private java.lang.Boolean closed;
				private java.lang.String outletId;
				private java.lang.String userId;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	
	// collections
	private java.util.List<com.floreantpos.model.Ticket> invoices;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: FROM_DATE
	 */

	public java.util.Date getFromDate () {
			return fromDate;
	}



	/**
	 * Set the value related to the column: FROM_DATE
	 * @param fromDate the FROM_DATE value
	 */
			public void setFromDate (java.util.Date fromDate) {
			this.fromDate = fromDate;
	}



	/**
	 * Return the value associated with the column: TO_DATE
	 */

	public java.util.Date getToDate () {
			return toDate;
	}



	/**
	 * Set the value related to the column: TO_DATE
	 * @param toDate the TO_DATE value
	 */
			public void setToDate (java.util.Date toDate) {
			this.toDate = toDate;
	}



	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
			return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
			public void setCreatedDate (java.util.Date createdDate) {
			this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: NEXT_BILLING_DATE
	 */

	public java.util.Date getNextBillingDate () {
			return nextBillingDate;
	}



	/**
	 * Set the value related to the column: NEXT_BILLING_DATE
	 * @param nextBillingDate the NEXT_BILLING_DATE value
	 */
			public void setNextBillingDate (java.util.Date nextBillingDate) {
			this.nextBillingDate = nextBillingDate;
	}



	/**
	 * Return the value associated with the column: BILLING_CYCLE_DURATION
	 */

	public java.lang.Integer getBillingCycleDuration () {
						return billingCycleDuration == null ? Integer.valueOf(0) : billingCycleDuration;
		}



	/**
	 * Set the value related to the column: BILLING_CYCLE_DURATION
	 * @param billingCycleDuration the BILLING_CYCLE_DURATION value
	 */
			public void setBillingCycleDuration (java.lang.Integer billingCycleDuration) {
			this.billingCycleDuration = billingCycleDuration;
	}



	/**
	 * Return the value associated with the column: BILLING_CYCLE_DURATION_TYPE
	 */

	public java.lang.String getBillingCycleDurationType () {
			return billingCycleDurationType;
	}



	/**
	 * Set the value related to the column: BILLING_CYCLE_DURATION_TYPE
	 * @param billingCycleDurationType the BILLING_CYCLE_DURATION_TYPE value
	 */
			public void setBillingCycleDurationType (java.lang.String billingCycleDurationType) {
			this.billingCycleDurationType = billingCycleDurationType;
	}



	/**
	 * Return the value associated with the column: RECURRING
	 */

	public java.lang.Boolean isRecurring () {
						return recurring == null ? Boolean.valueOf(false) : recurring;
			}

	public java.lang.Boolean getRecurring () {
					return recurring == null ? Boolean.valueOf(false) : recurring;
			}


	/**
	 * Set the value related to the column: RECURRING
	 * @param recurring the RECURRING value
	 */
			public void setRecurring (java.lang.Boolean recurring) {
			this.recurring = recurring;
	}


	/**
	 * Custom property
	 */
	public static String getRecurringDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: CUSTOMER_ID
	 */

	public java.lang.String getCustomerId () {
			return customerId;
	}



	/**
	 * Set the value related to the column: CUSTOMER_ID
	 * @param customerId the CUSTOMER_ID value
	 */
			public void setCustomerId (java.lang.String customerId) {
			this.customerId = customerId;
	}
			
			
	/**
	 * Return the value associated with the column: RENTAL_ITEM_ID
	 */

	public java.lang.String getRentalItemId () {
			return rentalItemId;
	}



	/**
	 * Set the value related to the column: RENTAL_ITEM_ID
	 * @param rentalItemId the RENTAL_ITEM_ID value
	 */
			public void setRentalItemId (java.lang.String rentalItemId) {
			this.rentalItemId = rentalItemId;
	}




	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: SUB_TOTAL
	 */

	public java.lang.Double getSubtotalAmount () {
						return subtotalAmount == null ? Double.valueOf(0) : subtotalAmount;
		}



	/**
	 * Set the value related to the column: SUB_TOTAL
	 * @param subtotalAmount the SUB_TOTAL value
	 */
			public void setSubtotalAmount (java.lang.Double subtotalAmount) {
			this.subtotalAmount = subtotalAmount;
	}



	/**
	 * Return the value associated with the column: TOTAL_DISCOUNT
	 */

	public java.lang.Double getDiscountAmount () {
						return discountAmount == null ? Double.valueOf(0) : discountAmount;
		}



	/**
	 * Set the value related to the column: TOTAL_DISCOUNT
	 * @param discountAmount the TOTAL_DISCOUNT value
	 */
			public void setDiscountAmount (java.lang.Double discountAmount) {
			this.discountAmount = discountAmount;
	}



	/**
	 * Return the value associated with the column: TOTAL_TAX
	 */

	public java.lang.Double getTaxAmount () {
						return taxAmount == null ? Double.valueOf(0) : taxAmount;
		}



	/**
	 * Set the value related to the column: TOTAL_TAX
	 * @param taxAmount the TOTAL_TAX value
	 */
			public void setTaxAmount (java.lang.Double taxAmount) {
			this.taxAmount = taxAmount;
	}



	/**
	 * Return the value associated with the column: TOTAL_PRICE
	 */

	public java.lang.Double getTotalAmount () {
						return totalAmount == null ? Double.valueOf(0) : totalAmount;
		}



	/**
	 * Set the value related to the column: TOTAL_PRICE
	 * @param totalAmount the TOTAL_PRICE value
	 */
			public void setTotalAmount (java.lang.Double totalAmount) {
			this.totalAmount = totalAmount;
	}



	/**
	 * Return the value associated with the column: PAID_AMOUNT
	 */

	public java.lang.Double getPaidAmount () {
						return paidAmount == null ? Double.valueOf(0) : paidAmount;
		}



	/**
	 * Set the value related to the column: PAID_AMOUNT
	 * @param paidAmount the PAID_AMOUNT value
	 */
			public void setPaidAmount (java.lang.Double paidAmount) {
			this.paidAmount = paidAmount;
	}



	/**
	 * Return the value associated with the column: VOID_AMOUNT
	 */

	public java.lang.Double getVoidAmount () {
						return voidAmount == null ? Double.valueOf(0) : voidAmount;
		}



	/**
	 * Set the value related to the column: VOID_AMOUNT
	 * @param voidAmount the VOID_AMOUNT value
	 */
			public void setVoidAmount (java.lang.Double voidAmount) {
			this.voidAmount = voidAmount;
	}



	/**
	 * Return the value associated with the column: REFUND_AMOUNT
	 */

	public java.lang.Double getRefundAmount () {
						return refundAmount == null ? Double.valueOf(0) : refundAmount;
		}



	/**
	 * Set the value related to the column: REFUND_AMOUNT
	 * @param refundAmount the REFUND_AMOUNT value
	 */
			public void setRefundAmount (java.lang.Double refundAmount) {
			this.refundAmount = refundAmount;
	}



	/**
	 * Return the value associated with the column: REFUNDABLE_AMOUNT
	 */

	public java.lang.Double getRefundableAmount () {
						return refundableAmount == null ? Double.valueOf(0) : refundableAmount;
		}



	/**
	 * Set the value related to the column: REFUNDABLE_AMOUNT
	 * @param refundableAmount the REFUNDABLE_AMOUNT value
	 */
			public void setRefundableAmount (java.lang.Double refundableAmount) {
			this.refundableAmount = refundableAmount;
	}



	/**
	 * Return the value associated with the column: DUE_AMOUNT
	 */

	public java.lang.Double getDueAmount () {
						return dueAmount == null ? Double.valueOf(0) : dueAmount;
		}



	/**
	 * Set the value related to the column: DUE_AMOUNT
	 * @param dueAmount the DUE_AMOUNT value
	 */
			public void setDueAmount (java.lang.Double dueAmount) {
			this.dueAmount = dueAmount;
	}



	/**
	 * Return the value associated with the column: FEE_AMOUNT
	 */

	public java.lang.Double getFeeAmount () {
						return feeAmount == null ? Double.valueOf(0) : feeAmount;
		}



	/**
	 * Set the value related to the column: FEE_AMOUNT
	 * @param feeAmount the FEE_AMOUNT value
	 */
			public void setFeeAmount (java.lang.Double feeAmount) {
			this.feeAmount = feeAmount;
	}



	/**
	 * Return the value associated with the column: ADVANCE_AMOUNT
	 */

	public java.lang.Double getAdvanceAmount () {
						return advanceAmount == null ? Double.valueOf(0) : advanceAmount;
		}



	/**
	 * Set the value related to the column: ADVANCE_AMOUNT
	 * @param advanceAmount the ADVANCE_AMOUNT value
	 */
			public void setAdvanceAmount (java.lang.Double advanceAmount) {
			this.advanceAmount = advanceAmount;
	}



	/**
	 * Return the value associated with the column: ROUNDED_AMOUNT
	 */

	public java.lang.Double getRoundedAmount () {
						return roundedAmount == null ? Double.valueOf(0) : roundedAmount;
		}



	/**
	 * Set the value related to the column: ROUNDED_AMOUNT
	 * @param roundedAmount the ROUNDED_AMOUNT value
	 */
			public void setRoundedAmount (java.lang.Double roundedAmount) {
			this.roundedAmount = roundedAmount;
	}



	/**
	 * Return the value associated with the column: VOIDED
	 */

	public java.lang.Boolean isVoided () {
					return voided == null ? Boolean.FALSE : voided;
		}

	public java.lang.Boolean getVoided () {
				return voided == null ? Boolean.FALSE : voided;
			}


	/**
	 * Set the value related to the column: VOIDED
	 * @param voided the VOIDED value
	 */
			public void setVoided (java.lang.Boolean voided) {
			this.voided = voided;
	}



	/**
	 * Return the value associated with the column: CLOSED
	 */

	public java.lang.Boolean isClosed () {
					return closed == null ? Boolean.FALSE : closed;
		}

	public java.lang.Boolean getClosed () {
				return closed == null ? Boolean.FALSE : closed;
			}


	/**
	 * Set the value related to the column: CLOSED
	 * @param closed the CLOSED value
	 */
			public void setClosed (java.lang.Boolean closed) {
			this.closed = closed;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: USER_ID
	 */

	public java.lang.String getUserId () {
			return userId;
	}



	/**
	 * Set the value related to the column: USER_ID
	 * @param userId the USER_ID value
	 */
			public void setUserId (java.lang.String userId) {
			this.userId = userId;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: invoices
	 */

	public java.util.List<com.floreantpos.model.Ticket> getInvoices () {
			return invoices;
	}



	/**
	 * Set the value related to the column: invoices
	 * @param invoices the invoices value
	 */
			public void setInvoices (java.util.List<com.floreantpos.model.Ticket> invoices) {
			this.invoices = invoices;
	}

	public void addToinvoices (com.floreantpos.model.Ticket ticket) {
		if (null == getInvoices()) setInvoices(new java.util.ArrayList<com.floreantpos.model.Ticket>());
		getInvoices().add(ticket);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.RentalLease)) return false;
		else {
			com.floreantpos.model.RentalLease lease = (com.floreantpos.model.RentalLease) obj;
			if (null == this.getId() || null == lease.getId()) return this == obj;
			else return (this.getId().equals(lease.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}