package com.floreantpos.model.dao;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.RentalScheduledJob;

public class RentalScheduledJobDAO extends BaseRentalScheduledJobDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public RentalScheduledJobDAO() {
	}

	public List<RentalScheduledJob> findAllActiveSchedules() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(RentalScheduledJob.PROP_ACTIVE, true));
			addDeletedFilter(criteria);
			return criteria.list();
		}
	}

	public RentalScheduledJob findByTicketId(String id) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(RentalScheduledJob.PROP_TICKET_ID, id));
			addDeletedFilter(criteria);
			return (RentalScheduledJob) criteria.uniqueResult();
		}
	}

	public RentalScheduledJob findByRentalLeaseId(String id) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(RentalScheduledJob.PROP_ID, id));
			addDeletedFilter(criteria);
			return (RentalScheduledJob) criteria.uniqueResult();
		}
	}
}