package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum MedicationDurationType {
	// @formatter:off
	DAY("Day"),
	MONTH("Month"),
	TIME("Time"),
	INFINITY("Infinity");
	// @formatter:on

	private final String displayName;

	MedicationDurationType(String displayName) {
		this.displayName = displayName;
	}

	public static MedicationDurationType fromString(String typeName) {
		if (StringUtils.isBlank(typeName)) {
			return null;
		}
		MedicationDurationType[] medicationDurationTypes = values();
		for (MedicationDurationType medicationDurationType : medicationDurationTypes) {
			if (medicationDurationType.name().equalsIgnoreCase(typeName)) {
				return medicationDurationType;
			}
		}
		return null;
	}

	@Override
	public String toString() {
		return displayName;
	}
}