package com.floreantpos.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.commons.lang.StringUtils;

public enum RentalDurationType {
	// @formatter:off
	HOUR("Hour","Hourly"),
	DAY("Day","Daily"),
	WEEK("Week","Weekly"),
	MONTH("Month","Monthly");
	// @formatter:on

	private final String displayName;
	private final String billingType;

	RentalDurationType(String displayName, String billingType) {
		this.displayName = displayName;
		this.billingType = billingType;
	}

	public static RentalDurationType fromString(String typeName) {
		if (StringUtils.isBlank(typeName)) {
			return RentalDurationType.DAY;
		}
		RentalDurationType[] durations = values();
		for (RentalDurationType duration : durations) {
			if (duration.name().equalsIgnoreCase(typeName)) {
				return duration;
			}
		}
		return RentalDurationType.DAY;
	}

	public double getHoursPerUnit() {
		switch (this) {
			case HOUR:
				return 1;
			case DAY:
				return 24;
			case WEEK:
				return 24 * 7;
			case MONTH:
				return 24 * 30;
			default:
				return 24; // Fallback
		}
	}

	// ✅ Add a type-safe conversion helper
	public double convertTo(RentalDurationType targetType) {
		return targetType.getHoursPerUnit() / this.getHoursPerUnit();
	}

	public String getDisplayName() {
		return displayName;
	}

	@Override
	public String toString() {
		return displayName;
	}

	public static Collection<RentalDurationType> getValuesAsList() {
		List<RentalDurationType> rentalDurationTypes = new ArrayList<RentalDurationType>();
		rentalDurationTypes.add(RentalDurationType.DAY);
		rentalDurationTypes.add(RentalDurationType.WEEK);
		rentalDurationTypes.add(RentalDurationType.MONTH);
		return rentalDurationTypes;
	}

	public String getBillingType() {
		return billingType;
	}
}