package com.floreantpos.model;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseDoctor;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.OrgJsonUtil;
import com.floreantpos.util.POSUtil;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true)
public class Doctor extends BaseDoctor {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Doctor() {
	}

	/**
	 * Constructor for primary key
	 */
	public Doctor(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public String getDoctorTypeDisplayName() {
		if (StringUtils.isBlank(getId())) {
			return null;
		}
		if (getIndorDoctor()) {
			return AgentTypeEnum.INDOOR_DOCTOR.getDisplayString();
		}
		return AgentTypeEnum.OUTDOOR_DOCTOR.getDisplayString();
	}

	@XmlTransient
	@JsonIgnore
	public List<DoctorTimeSchedule> getSchedules() {
		List<DoctorTimeSchedule> dataList = new ArrayList<>();
		JSONObject jsonProperties = getPropertiesContainer();
		if (jsonProperties == null || !jsonProperties.has("appointmentTimes")) { //$NON-NLS-1$
			return dataList;
		}
		JSONArray jsonArray = jsonProperties.getJSONArray("appointmentTimes"); //$NON-NLS-1$
		for (int i = 0; i < jsonArray.length(); i++) {
			JSONObject jsonObject = jsonArray.getJSONObject(i);
			DoctorTimeSchedule data = new DoctorTimeSchedule();
			data.setShiftName(OrgJsonUtil.getString(jsonObject, DoctorTimeSchedule.PROP_SHIFT_NAME));
			data.setStartTime(OrgJsonUtil.getString(jsonObject, DoctorTimeSchedule.PROP_START_TIME));
			data.setEndTime(OrgJsonUtil.getString(jsonObject, DoctorTimeSchedule.PROP_END_TIME));
			data.setConsultationTime(OrgJsonUtil.getInt(jsonObject, DoctorTimeSchedule.PROP_CONSULTATION_TIME));
			data.setConsultationFees(OrgJsonUtil.getDouble(jsonObject, DoctorTimeSchedule.PROP_CONSULTATION_FEES));
			data.setPatientCount(OrgJsonUtil.getInt(jsonObject, DoctorTimeSchedule.PROP_PATIENT_COUNT));
			data.setId(OrgJsonUtil.getString(jsonObject, DoctorTimeSchedule.PROP_ID));
			data.setDoctorId(this.getId());
			List<Integer> days = new ArrayList<>();
			JSONArray daysArray = jsonObject.has("days") ? jsonObject.getJSONArray("days") : null;
			for (int j = 0; j < daysArray.length(); j++) {
				days.add(daysArray.getInt(j));
			}
			data.setDays(days);
			dataList.add(data);
		}
		return dataList;
	}

	public void setSchedules(List<DoctorTimeSchedule> dataList) {
		if (dataList == null) {
			dataList = new ArrayList<>();
		}
		JSONArray dataArray = new JSONArray();
		for (DoctorTimeSchedule data : dataList) {
			JSONObject jsonObject = new JSONObject();
			jsonObject.put(DoctorTimeSchedule.PROP_CONSULTATION_TIME, data.getConsultationTime());
			jsonObject.put(DoctorTimeSchedule.PROP_CONSULTATION_FEES, data.getConsultationFees());
			jsonObject.put(DoctorTimeSchedule.PROP_PATIENT_COUNT, data.getPatientCount());
			jsonObject.put(DoctorTimeSchedule.PROP_DAYS, data.getDays());
			jsonObject.put(DoctorTimeSchedule.PROP_END_TIME, data.getEndTime());
			jsonObject.put(DoctorTimeSchedule.PROP_START_TIME, data.getStartTime());
			jsonObject.put(DoctorTimeSchedule.PROP_SHIFT_NAME, data.getShiftName());
			jsonObject.put(DoctorTimeSchedule.PROP_ID, data.getId());
			dataArray.put(jsonObject);
		}
		buildPropertis();
		getPropertiesContainer().put("appointmentTimes", dataArray); //$NON-NLS-1$
		setProperties(getPropertiesContainer().toString());
	}

	public void addOrUpdateSchedule(DoctorTimeSchedule schedule) {
		boolean dataExists = false;
		List<DoctorTimeSchedule> schedules = getSchedules();
		if (schedule.getId() != null && schedules != null && schedules.size() > 0) {
			for (DoctorTimeSchedule doctorTimeSchedule : schedules) {
				if (doctorTimeSchedule.getId() != null && doctorTimeSchedule.getId().equalsIgnoreCase(schedule.getId())) {
					doctorTimeSchedule.setConsultationTime(schedule.getConsultationTime());
					doctorTimeSchedule.setConsultationFees(schedule.getConsultationFees());
					doctorTimeSchedule.setDays(schedule.getDays());
					doctorTimeSchedule.setEndTime(schedule.getEndTime());
					doctorTimeSchedule.setPatientCount(schedule.getPatientCount());
					doctorTimeSchedule.setShiftName(schedule.getShiftName());
					doctorTimeSchedule.setStartTime(schedule.getStartTime());
					doctorTimeSchedule.setPatientCount(schedule.getPatientCount());
					dataExists = true;
					break;
				}
			}
		}
		if (!dataExists) {
			if (schedules == null) {
				schedules = new ArrayList<>();
			}
			if (StringUtils.isBlank(schedule.getId())) {
				schedule.setId(GlobalIdGenerator.generateGlobalId());
			}
			schedules.add(schedule);
		}
		setSchedules(schedules);
	}

	public Boolean isAllowDigitalSignature() {
		return POSUtil.getBoolean(getProperty("allowDigitalSignature"), false); //$NON-NLS-1$
	}

	public void setAllowDigitalSignature(boolean enableDigitalSignature) {
		addProperty("allowDigitalSignature", String.valueOf(enableDigitalSignature)); //$NON-NLS-1$
	}

}