package com.floreantpos.model;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.astm.AstmUtil.Test;
import com.floreantpos.model.base.BaseMachineResult;
import com.floreantpos.model.util.DateUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true)
@XmlAccessorType(XmlAccessType.FIELD)
public class MachineResult extends BaseMachineResult implements PropertyContainer2, TimedModel {
	private static final long serialVersionUID = 1L;
	private transient JsonObject propertiesContainer;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public MachineResult() {
	}

	/**
	 * Constructor for primary key
	 */
	public MachineResult(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProprties = super.getProperties();
		if (StringUtils.isEmpty(jsonProprties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProprties, com.google.gson.JsonObject.class);
		}
		return propertiesContainer;
	}

	@Override
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	@Override
	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	@Override
	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	@Override
	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public String getMachineNameDisplay() {
		Test test = new Gson().fromJson(getResultJson(), Test.class);
		return test.machine;
	}

	public void setMachineNameDisplay(String test) {
	}

	public String getResultDateDisplay() {
		Date convertServerTimeToBrowserTime = DateUtil.convertServerTimeToBrowserTime(getResultDate());
		return DateUtil.format("dd-MM-yy hh:mm a", convertServerTimeToBrowserTime); //$NON-NLS-1$
	}

	public void setResultDateDisplay(Date date) {
	}

	public void putMachineRawData(String rawData) {
		addProperty("machine.raw.data", rawData); //$NON-NLS-1$
	}

	public String getMachineRawData() {
		return getProperty("machine.raw.data", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}
}