/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BasePayOutTransaction;
import com.floreantpos.model.dao.PayoutReasonDAO;
import com.floreantpos.model.dao.PayoutRecepientDAO;

@XmlRootElement
public class PayOutTransaction extends BasePayOutTransaction {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public PayOutTransaction() {
	}

	/**
	 * Constructor for primary key
	 */
	public PayOutTransaction(java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public PayOutTransaction(java.lang.String id, java.lang.String transactionType, java.lang.String paymentTypeString) {

		super(id, transactionType, paymentTypeString);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String getTransactionType() {
		String type = super.getTransactionType();

		if (StringUtils.isEmpty(type)) {
			return TransactionType.DEBIT.name();
		}

		return type;
	}

	private PayoutReason reason;
	private PayoutRecepient recepient;

	public String getReasonDisplay() {
		PayoutReason reason = getReason();
		return reason == null ? "" : reason.getReason(); //$NON-NLS-1$
	}

	public PayoutReason getReason() {
		String payoutReason = getReasonId();
		if (reason != null && reason.getId().equals(payoutReason))
			return reason;
		if (StringUtils.isNotEmpty(payoutReason)) {
			reason = PayoutReasonDAO.getInstance().get(payoutReason);
		}
		return reason;
	}

	public void setReason(PayoutReason payoutReason) {
		this.reason = payoutReason;
		String payoutReasonId = null;
		if (payoutReason != null) {
			payoutReasonId = payoutReason.getId();
		}
		super.setReasonId(payoutReasonId);
	}

	public String getRecepientDisplay() {
		PayoutRecepient payoutRecepient = getRecepient();
		return payoutRecepient == null ? "" : payoutRecepient.getName(); //$NON-NLS-1$

	}

	public PayoutRecepient getRecepient() {
		String payoutPayoutRecepient = getRecepientId();
		if (recepient != null && recepient.getId().equals(payoutPayoutRecepient))
			return recepient;
		if (StringUtils.isNotEmpty(payoutPayoutRecepient)) {
			recepient = PayoutRecepientDAO.getInstance().get(payoutPayoutRecepient);
		}
		return recepient;
	}

	public void setRecepient(PayoutRecepient payoutPayoutRecepient) {
		this.recepient = payoutPayoutRecepient;
		String recepientId = null;
		if (payoutPayoutRecepient != null) {
			recepientId = payoutPayoutRecepient.getId();
		}
		super.setRecepientId(recepientId);
	}

	public void putExpenses(boolean isExpenses) {
		addProperty("expenses", String.valueOf(isExpenses)); //$NON-NLS-1$
	}

	public boolean isExpenses() {
		return isPropertyValueTrue("expenses"); //$NON-NLS-1$
	}

}