package com.floreantpos.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseStockCountItem;
import com.floreantpos.model.dao.MenuItemDAO;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true, value = { "menuItem", "stockCount" })
public class StockCountItem extends BaseStockCountItem {
	private static final long serialVersionUID = 1L;

	private transient Map<String, Object> tmpValueMap = new HashMap<>();

	public StockCountItem() {
	}

	public StockCountItem(java.lang.String id) {
		super(id);
	}

	public StockCountItem(java.lang.String id, com.floreantpos.model.StockCount stockCount) {

		super(id, stockCount);
	}

	private MenuItem menuItem;

	@XmlTransient
	public MenuItem getMenuItem() {
		if (menuItem == null) {
			String itemId = getItemId();
			if (StringUtils.isEmpty(itemId)) {
				return null;
			}
			menuItem = MenuItemDAO.getInstance().loadInitialized(itemId);
		}

		return menuItem;
	}

	public void setMenuItem(MenuItem menuItem) {
		this.menuItem = menuItem;
	}

	public double getCountVariance() {
		return getActualUnit() - getUnitOnHand();
	}

	public void setCountVariance(double countVariance) {
	}

	public double getCostVariance() {
		return getCountVariance() * getCost();
	}

	public void setCostVariance(double costVariance) {
	}

	public List<IUnit> getUnits() {
		menuItem = getMenuItem();
		if (menuItem != null && ProductType.match(menuItem.getProductType(), ProductType.MEDICINE)) {
			return menuItem.getUnits();
		}
		return null;
	}

	public void putTmpValue(String key, Object value) {
		tmpValueMap.put(key, value);
	}

	public <T> T getTmpValue(String key) {
		Object object = tmpValueMap.get(key);
		if (object == null) {
			return null;
		}
		return (T) object;
	}

}