package com.floreantpos.model.util;

import org.apache.commons.lang.StringUtils;

public enum ServiceChargeType {
	//@formatter:off
		EMPTY(""), //$NON-NLS-1$
		PERCENTAGE("Percentage"),
		FIXEDAMOUNT("Fixed amount") 
		;
		//@formatter:on

	String displayString;

	private ServiceChargeType(String display) {
		this.displayString = display;
	}

	@Override
	public String toString() {
		return displayString;
	}

	public String getDisplayString() {
		return displayString;
	}

	public static ServiceChargeType fromName(String name) {
		if (StringUtils.isEmpty(name)) {
			return ServiceChargeType.PERCENTAGE;
		}

		ServiceChargeType[] values = values();
		for (ServiceChargeType chargeType : values) {
			if (name.equals(chargeType.name())) {
				return chargeType;
			}
		}

		return ServiceChargeType.PERCENTAGE;
	}
}
