package com.floreantpos.report.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.swing.ListTableModel;

public class BalanceSheetReportModel extends ListTableModel {
	public BalanceSheetReportModel() {
		super(new String[] { "coaId", "coaName", "amount", "groupName" }); //$NON-NLS-1$ //$NON-NLS-2$ 

	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		BalanceSheetLedgerEntryModel data = (BalanceSheetLedgerEntryModel) rows.get(rowIndex);
		String coaId = data.getCoaId();

		switch (columnIndex) {
			case 0:
				return coaId;

			case 1:
				return data.getCoaName(); //$NON-NLS-1$

			case 2:
				return data.getAmount();

			case 3:
				return data.getGroupName();
		}
		return null;
	}

}
