package com.floreantpos.services;

import org.hibernate.Session;

import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.InventoryStockUnitDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;

public class InventoryService {

	private static InventoryService instance;

	public static InventoryService getInstance() {
		if (instance == null) {
			instance = new InventoryService();
		}
		return instance;
	}

	private InventoryService() {
	}

	public void adjustMenuItemCost(MenuItem menuItem, double newCost, double newQuantity, InventoryUnit selectedUnit) {
		adjustMenuItemCost(menuItem, newCost, newCost, newQuantity, selectedUnit);
	}

	public void adjustMenuItemCost(MenuItem menuItem, double newCost, double unitPrice, double newQuantity, InventoryUnit selectedUnit) {
		MenuItemDAO.getInstance().refresh(menuItem);
		try (Session session = TerminalDAO.getInstance().createNewSession()) {
			this.adjustMenuItemCost(menuItem, newCost, unitPrice, newQuantity, selectedUnit, session);
		}
	}

	public void adjustMenuItemCost(MenuItem menuItem, double newCost, double unitPrice, double newQuantity, IUnit selectedUnit, Session session) {
		adjustMenuItemCost(menuItem, newCost, unitPrice, unitPrice, newQuantity, selectedUnit, session);
	}

	public void adjustMenuItemCost(MenuItem menuItem, double newCost, double unitPrice, double mrpPrice, double newQuantity, IUnit selectedUnit,
			Session session) {
		Store store = DataProvider.get().getStore();
		if (store == null || menuItem == null || selectedUnit == null || session == null) {
			return;
		}
		Double menuItemOldCost = menuItem.getCost();
		//MenuItemDAO.getInstance().refresh(menuItem, session);
		if (selectedUnit instanceof InventoryUnit) {
			InventoryUnit baseUnit = menuItem.getUnit();

			if (selectedUnit != null && baseUnit != null && !baseUnit.equals(selectedUnit)) {
				Double selectedConversionRate = selectedUnit.getConversionRate();
				Double baseConversionRate = baseUnit.getConversionRate();
				newCost = newCost * (selectedConversionRate / baseConversionRate);
				newQuantity = newQuantity * menuItem.getUnitQuantity(selectedUnit, baseUnit);
			}

		}
		else if (selectedUnit instanceof InventoryStockUnit) {
			InventoryStockUnit inventoryStockUnit = (InventoryStockUnit) selectedUnit;
			if (unitPrice > 0) {
				inventoryStockUnit.setPrice(unitPrice);
				if (newCost > 0) {
					inventoryStockUnit.setCost(newCost);
				}
				InventoryStockUnitDAO.getInstance().saveOrUpdate(inventoryStockUnit, session);
			}
		}

		Double menuItemOnHand = menuItem.getUnitOnHand();
		if (menuItemOnHand < 0) {
			menuItemOnHand = 0.0;
		}

		double menuItemAverageCost = (menuItemOnHand * menuItemOldCost + newQuantity * newCost) / (menuItemOnHand + newQuantity);

		if (store.isInventoryAvgPricingMethod()) {
			if (menuItemAverageCost > 0) {
				menuItem.setCost(menuItemAverageCost);
			}
		}
		else {
			if (newCost > 0) {
				menuItem.setCost(newCost);
			}
		}

		menuItem.setLastPurchasedCost(newCost);
		menuItem.setAverageUnitPurchasePrice(menuItemAverageCost);
	}
}
