package com.floreantpos.util;

import java.text.DecimalFormat;
import java.util.Date;

import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;

public class BatchNoGenerator {

	public static String generateBatchNo() {

		String date = SequenceNumber.yearMonthDayFormat.format(new Date());

		DecimalFormat decimalFormat = new DecimalFormat("0");
		int num = 0;

		SequenceNumberDAO instance = SequenceNumberDAO.getInstance();
		SequenceNumber lastSequenceNumber = instance.getLastSequenceNumber(SequenceNumber.POS_TRANSACTION_BATCH_NO, date);
		if (lastSequenceNumber != null) {
			num = lastSequenceNumber.getNextSequenceNumber() - 1;
		}
		else {
			num = instance.getNextSequenceNumber(SequenceNumber.POS_TRANSACTION_BATCH_NO, date);
		}

		String batchNo = date + decimalFormat.format(num);

		while (PosTransactionDAO.getInstance().isPresent(batchNo)) {
			batchNo = date + decimalFormat.format(instance.getNextSequenceNumber(SequenceNumber.POS_TRANSACTION_BATCH_NO, date));
		}

		return batchNo;
	}

	public static String generatePayoutBatchNo(boolean isExpenses) {
		if (isExpenses) {
			return generateBatchNoForTransaction(SequenceNumber.EXPENSES_BATCH_NO);
		}
		return generateBatchNoForTransaction(SequenceNumber.PAYOUT_BATCH_NO);
	}

	public static String generateBatchNoForTransaction(String type) {

		String date = SequenceNumber.yearMonthDayFormat.format(new Date());

		DecimalFormat decimalFormat = new DecimalFormat("0");
		int num = 0;

		SequenceNumberDAO instance = SequenceNumberDAO.getInstance();
		SequenceNumber lastSequenceNumber = instance.getLastSequenceNumber(type, date);
		if (lastSequenceNumber != null) {
			num = lastSequenceNumber.getNextSequenceNumber() - 1;
		}
		else {
			num = instance.getNextSequenceNumber(type, date);
		}

		String batchNo = date + decimalFormat.format(num);

		while (PosTransactionDAO.getInstance().isPresent(batchNo)) {
			batchNo = date + decimalFormat.format(instance.getNextSequenceNumber(type, date));
		}

		return batchNo;
	}
}
