package com.floreantpos.util;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import javax.imageio.ImageIO;

import org.imgscalr.Scalr;

public class ImageUtil {

	public static String IMAGE_FORMAT_PNG = "png";

	public static byte[] convertImageToByteArray(BufferedImage image) throws IOException {
		try (ByteArrayOutputStream baos = new ByteArrayOutputStream()) {
			ImageIO.write(image, IMAGE_FORMAT_PNG, baos);
			baos.flush();
			return baos.toByteArray();
		}
	}

	public static BufferedImage reduceImageFileSize(BufferedImage image, int size) throws IOException {
		BufferedImage resize = Scalr.resize(image, size, (BufferedImageOp) null);
		byte[] imageToByteArray = convertImageToByteArray(resize);
		int imageSize = imageToByteArray.length / 1024;

		if (imageSize > 1000) {
			return reduceImageFileSize(image, size / 2);
		}
		return resize;
	}

}
