package com.floreantpos.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;

import com.floreantpos.PosLog;
import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;

public class TicketIdGenerator implements IdentifierGenerator {
	@Override
	public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
		Class<? extends Object> clazz = object.getClass();
		Serializable generatedId = null;
		try {
			Method method = clazz.getMethod("getId", (Class<?>[]) null); //$NON-NLS-1$
			if (method != null) {
				Object id = method.invoke(object, (Object[]) null);
				if (id != null) {
					generatedId = (Serializable) id;
				}
			}

			if (generatedId == null) {
				generatedId = generateTicketId((Session) session, DataProvider.get().getOutletId());
			}
		} catch (Exception e) {
			PosLog.error(TicketIdGenerator.class, e);
		}

		return generatedId;
	}

	public static String generateTicketId(String outletId) {
		return generateTicketId(outletId, false);
	}

	public static String generateTicketId(String outletId, boolean ispharma) {
		try (Session session = TicketDAO.getInstance().createNewSession()) {
			return generateTicketId(session, outletId, ispharma);
		}
	}

	public static String generateTicketId(Session session, String outletId) {
		return generateTicketId(session, outletId, false);
	}

	public static String generateTicketId(Session session, String outletId, boolean ispharma) {
		if (StringUtils.isBlank(outletId)) {
			outletId = DataProvider.get().getOutletId();
		}

		String prefix = SequenceNumber.yearMonthDayFormat.format(new Date());
		if (ispharma) {
			prefix = "P" + prefix;
		}
		String ticketId = prefix + SequenceNumber.threeDigitDecimalFormat
				.format(SequenceNumberDAO.getInstance().getNextSequenceNumber(SequenceNumber.TICKET_SEQUENCE_NUMBER, prefix));
		while (TicketDAO.getInstance().get(ticketId, outletId, session) != null) {
			ticketId = prefix + SequenceNumber.threeDigitDecimalFormat
					.format(SequenceNumberDAO.getInstance().getNextSequenceNumber(SequenceNumber.TICKET_SEQUENCE_NUMBER, prefix));
		}

		return ticketId;
	}
}
