package com.floreantpos.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BasePrescription;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true)
@XmlAccessorType(XmlAccessType.FIELD)
public class Prescription extends BasePrescription implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;
	private Customer patient;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Prescription() {
	}

	/**
	 * Constructor for primary key
	 */
	public Prescription(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public String getPatientNameByProperty() {
		return getProperty(Ticket.CUSTOMER_NAME);
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public String getPatientPhoneNo() {
		return getProperty(Ticket.CUSTOMER_PHONE);
	}

	public Customer getPatient() {
		return patient;
	}

	public void setPatient(Customer patient) {
		this.patient = patient;
		setPatientId(patient == null ? null : patient.getId());
		if (patient != null) {
			addProperty(Ticket.CUSTOMER_ID, String.valueOf(patient.getId()));
			addProperty(Ticket.CUSTOMER_NAME, patient.getFirstName());
			addProperty(Ticket.CUSTOMER_LAST_NAME, patient.getLastName());
			addProperty(Ticket.CUSTOMER_PHONE, patient.getMobileNo());
			addProperty(Ticket.CUSTOMER_ZIP_CODE, patient.getZipCode());
			addProperty(Ticket.CUSTOMER_TAX_EXEMPT, patient.isTaxExempt().toString());
			addProperty(Ticket.CUSTOMER_EMAIL, patient.getEmail());
		}
	}

}