package com.floreantpos.model.base;

import java.io.Serializable;


/**
 * This is an object that contains data related to the LEDGER_ENTRY table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="LEDGER_ENTRY"
 */

public abstract class BaseLedgerEntry  implements Serializable {

	public static String REF = "LedgerEntry"; //$NON-NLS-1$
	public static String PROP_ACCOUNT_ID = "accountId"; //$NON-NLS-1$
	public static String PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static String PROP_RECEPIENT_ID = "recepientId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_CREATE_DATE = "createDate"; //$NON-NLS-1$
	public static String PROP_DIRECTION = "direction"; //$NON-NLS-1$
	public static String PROP_DOCTOR_ID = "doctorId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_SALES_ORDER_ID = "salesOrderId"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_CASH_DRAWER_ID = "cashDrawerId"; //$NON-NLS-1$
	public static String PROP_PATIENT_ID = "patientId"; //$NON-NLS-1$
	public static String PROP_PURCHASE_ORDER_ID = "purchaseOrderId"; //$NON-NLS-1$
	public static String PROP_AGENT_ID = "agentId"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_AMOUNT = "amount"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_GROUP_ID = "groupId"; //$NON-NLS-1$
	public static String PROP_TRANSACTION_ID = "transactionId"; //$NON-NLS-1$
	public static String PROP_TICKET_ID = "ticketId"; //$NON-NLS-1$
	public static String PROP_USER_ID = "userId"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_PAYOUT_RECEPIENT_ID = "payoutRecepientId"; //$NON-NLS-1$


	// constructors
	public BaseLedgerEntry () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseLedgerEntry (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.lang.String outletId;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date createDate;
				private java.lang.Integer sortOrder;
				private java.lang.String groupId;
				private java.lang.String purchaseOrderId;
				private java.lang.String salesOrderId;
				private java.lang.String ticketId;
				private java.lang.String transactionId;
				private java.lang.String accountId;
				private java.lang.String userId;
				private java.lang.String patientId;
				private java.lang.String recepientId;
				private java.lang.String agentId;
				private java.lang.String doctorId;
				private java.lang.String payoutRecepientId;
				private java.lang.String cashDrawerId;
				private java.lang.Integer direction;
				private java.lang.Double amount;
				private java.lang.String description;
				private java.lang.String ledgerEntryType;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: CREATE_DATE
	 */

	public java.util.Date getCreateDate () {
			return createDate;
	}



	/**
	 * Set the value related to the column: CREATE_DATE
	 * @param createDate the CREATE_DATE value
	 */
			public void setCreateDate (java.util.Date createDate) {
			this.createDate = createDate;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
						return sortOrder == null ? Integer.valueOf(0) : sortOrder;
		}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: GROUP_ID
	 */

	public java.lang.String getGroupId () {
			return groupId;
	}



	/**
	 * Set the value related to the column: GROUP_ID
	 * @param groupId the GROUP_ID value
	 */
			public void setGroupId (java.lang.String groupId) {
			this.groupId = groupId;
	}



	/**
	 * Return the value associated with the column: PURCHASE_ORDER_ID
	 */

	public java.lang.String getPurchaseOrderId () {
			return purchaseOrderId;
	}



	/**
	 * Set the value related to the column: PURCHASE_ORDER_ID
	 * @param purchaseOrderId the PURCHASE_ORDER_ID value
	 */
			public void setPurchaseOrderId (java.lang.String purchaseOrderId) {
			this.purchaseOrderId = purchaseOrderId;
	}



	/**
	 * Return the value associated with the column: SALES_ORDER_ID
	 */

	public java.lang.String getSalesOrderId () {
			return salesOrderId;
	}



	/**
	 * Set the value related to the column: SALES_ORDER_ID
	 * @param salesOrderId the SALES_ORDER_ID value
	 */
			public void setSalesOrderId (java.lang.String salesOrderId) {
			this.salesOrderId = salesOrderId;
	}



	/**
	 * Return the value associated with the column: TICKET_ID
	 */

	public java.lang.String getTicketId () {
			return ticketId;
	}



	/**
	 * Set the value related to the column: TICKET_ID
	 * @param ticketId the TICKET_ID value
	 */
			public void setTicketId (java.lang.String ticketId) {
			this.ticketId = ticketId;
	}



	/**
	 * Return the value associated with the column: TRANSACTION_ID
	 */

	public java.lang.String getTransactionId () {
			return transactionId;
	}



	/**
	 * Set the value related to the column: TRANSACTION_ID
	 * @param transactionId the TRANSACTION_ID value
	 */
			public void setTransactionId (java.lang.String transactionId) {
			this.transactionId = transactionId;
	}



	/**
	 * Return the value associated with the column: ACCOUNT_ID
	 */

	public java.lang.String getAccountId () {
			return accountId;
	}



	/**
	 * Set the value related to the column: ACCOUNT_ID
	 * @param accountId the ACCOUNT_ID value
	 */
			public void setAccountId (java.lang.String accountId) {
			this.accountId = accountId;
	}



	/**
	 * Return the value associated with the column: USER_ID
	 */

	public java.lang.String getUserId () {
			return userId;
	}



	/**
	 * Set the value related to the column: USER_ID
	 * @param userId the USER_ID value
	 */
			public void setUserId (java.lang.String userId) {
			this.userId = userId;
	}


			/**
			 * Return the value associated with the column: PATIENT_ID
			 */

			public java.lang.String getPatientId () {
					return patientId;
			}



			/**
			 * Set the value related to the column: PATIENT_ID
			 * @param patientId the PATIENT_ID value
			 */
					public void setPatientId (java.lang.String patientId) {
					this.patientId = patientId;
			}

	/**
	 * Return the value associated with the column: RECEPIENT_ID
	 */

	public java.lang.String getRecepientId () {
			return recepientId;
	}



	/**
	 * Set the value related to the column: RECEPIENT_ID
	 * @param recepientId the RECEPIENT_ID value
	 */
			public void setRecepientId (java.lang.String recepientId) {
			this.recepientId = recepientId;
	}



	/**
	 * Return the value associated with the column: AGENT_ID
	 */

	public java.lang.String getAgentId () {
			return agentId;
	}



	/**
	 * Set the value related to the column: AGENT_ID
	 * @param agentId the AGENT_ID value
	 */
			public void setAgentId (java.lang.String agentId) {
			this.agentId = agentId;
	}



	/**
	 * Return the value associated with the column: DOCTOR_ID
	 */

	public java.lang.String getDoctorId () {
			return doctorId;
	}



	/**
	 * Set the value related to the column: DOCTOR_ID
	 * @param doctorId the DOCTOR_ID value
	 */
			public void setDoctorId (java.lang.String doctorId) {
			this.doctorId = doctorId;
	}



	/**
	 * Return the value associated with the column: PAYOUT_RECEPIENT_ID
	 */

	public java.lang.String getPayoutRecepientId () {
			return payoutRecepientId;
	}



	/**
	 * Set the value related to the column: PAYOUT_RECEPIENT_ID
	 * @param payoutRecepientId the PAYOUT_RECEPIENT_ID value
	 */
			public void setPayoutRecepientId (java.lang.String payoutRecepientId) {
			this.payoutRecepientId = payoutRecepientId;
	}



	/**
	 * Return the value associated with the column: CASH_DRAWER_ID
	 */

	public java.lang.String getCashDrawerId () {
			return cashDrawerId;
	}



	/**
	 * Set the value related to the column: CASH_DRAWER_ID
	 * @param cashDrawerId the CASH_DRAWER_ID value
	 */
			public void setCashDrawerId (java.lang.String cashDrawerId) {
			this.cashDrawerId = cashDrawerId;
	}



	/**
	 * Return the value associated with the column: DIRECTION
	 */

	public java.lang.Integer getDirection () {
						return direction == null ? Integer.valueOf(0) : direction;
		}



	/**
	 * Set the value related to the column: DIRECTION
	 * @param direction the DIRECTION value
	 */
			public void setDirection (java.lang.Integer direction) {
			this.direction = direction;
	}



	/**
	 * Return the value associated with the column: AMOUNT
	 */

	public java.lang.Double getAmount () {
						return amount == null ? Double.valueOf(0) : amount;
		}



	/**
	 * Set the value related to the column: AMOUNT
	 * @param amount the AMOUNT value
	 */
			public void setAmount (java.lang.Double amount) {
			this.amount = amount;
	}



	/**
	 * Return the value associated with the column: DESCRIPTION
	 */

	public java.lang.String getDescription () {
			return description;
	}



	/**
	 * Set the value related to the column: DESCRIPTION
	 * @param description the DESCRIPTION value
	 */
			public void setDescription (java.lang.String description) {
			this.description = description;
	}



	/**
	 * Return the value associated with the column: LEDGER_ENTRY_TYPE
	 */

	public java.lang.String getLedgerEntryType () {
			return ledgerEntryType;
	}



	/**
	 * Set the value related to the column: LEDGER_ENTRY_TYPE
	 * @param ledgerEntryType the LEDGER_ENTRY_TYPE value
	 */
			public void setLedgerEntryType (java.lang.String ledgerEntryType) {
			this.ledgerEntryType = ledgerEntryType;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}



	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.LedgerEntry)) return false;
		else {
			com.floreantpos.model.LedgerEntry ledgerEntry = (com.floreantpos.model.LedgerEntry) obj;
			if (null == this.getId() || null == ledgerEntry.getId()) return this == obj;
			else return (this.getId().equals(ledgerEntry.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}