package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;

import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.swing.PaginationSupport;

public class CustomPaymentTransactionDAO extends BaseCustomPaymentTransactionDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public CustomPaymentTransactionDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public void loadCustomTransactions(PaginationSupport model, String noteText) {
		loadCustomTransactions(model, null, null, null, noteText);
	}

	public void loadCustomTransactions(PaginationSupport model, String ticketIdOrCustomerName, Date fromDate, Date toDate, String noteText) {

		try (Session session = createNewSession()) {

			Criteria criteriaCustomer = session.createCriteria(Customer.class);
			List<String> customerIds = null;
			if (StringUtils.isNotEmpty(ticketIdOrCustomerName)) {
				criteriaCustomer.setProjection(Projections.property(Customer.PROP_ID));
				criteriaCustomer.add(Restrictions.ilike(Customer.PROP_NAME, ticketIdOrCustomerName, MatchMode.ANYWHERE));
				customerIds = criteriaCustomer.list();
			}

			Criteria criteria = session.createCriteria(PosTransaction.class);
			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(PosTransaction.PROP_VOIDED, Boolean.FALSE));
			criteria.add(Restrictions.ilike(PosTransaction.PROP_EXTRA_PROPERTIES, "\"confirm.payment\":", MatchMode.ANYWHERE)); //$NON-NLS-1$

			Disjunction orRest = Restrictions.disjunction();
			if (StringUtils.isNotBlank(ticketIdOrCustomerName)) {
				criteria.createAlias(CustomPaymentTransaction.PROP_TICKET, "ticket", JoinType.FULL_JOIN); //$NON-NLS-1$
				orRest.add(Restrictions.ilike("ticket." + Ticket.PROP_ID, ticketIdOrCustomerName, MatchMode.ANYWHERE)); //$NON-NLS-1$
				
				orRest.add(Restrictions.ilike(PosTransaction.PROP_ENTITY_NO, ticketIdOrCustomerName, MatchMode.ANYWHERE));

				if (customerIds != null && customerIds.size() > 0) {
					orRest.add(Restrictions.in(CustomPaymentTransaction.PROP_CUSTOMER_ID, customerIds));
				}
				criteria.add(orRest);
			}
			else if (StringUtils.isNoneBlank(noteText)) {
				criteria.add(Restrictions.ilike(CustomPaymentTransaction.PROP_EXTRA_PROPERTIES, noteText, MatchMode.ANYWHERE));
			}

			if (fromDate != null && toDate != null) {
				criteria.add(Restrictions.ge(PosTransaction.PROP_TRANSACTION_TIME, fromDate));
				criteria.add(Restrictions.le(PosTransaction.PROP_TRANSACTION_TIME, toDate));
			}
			criteria.setProjection(Projections.rowCount());

			Number uniqueResult = (Number) criteria.uniqueResult();
			model.setNumRows(uniqueResult.intValue());
			criteria.setProjection(null);

			criteria.setFirstResult(model.getCurrentRowIndex());
			criteria.setMaxResults(model.getPageSize());

			criteria.addOrder(Order.desc(PosTransaction.PROP_TRANSACTION_TIME));

			criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
			model.setRows(criteria.list());
		}

	}
}