package com.floreantpos.model.ext;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.constants.AppConstants;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.util.DataProvider;

public enum PaperSize {

	A4("A4"), A5("A5"), LETTER("Letter"), EIGHTY("80mm"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$

	private String name;
	PaperSize(String name) {
		this.name = name;
	}

	public static String getReportNameAccording2Size(String reportName) {
		Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
		if (currentTerminal == null) {
			return reportName;
		}
		String paperSize = currentTerminal.getProperty(AppConstants.REPORT_PAPER_SIZE);
		if (LETTER.name().equalsIgnoreCase(paperSize)) {
			reportName = reportName + "-letter"; //$NON-NLS-1$
		}
		return reportName;
	}

	public static PaperSize fromString(String paperSize) {
		if (StringUtils.isBlank(paperSize)) {
			return null;
		}

		return PaperSize.valueOf(paperSize);
	}
	
	@Override
	public String toString() {
		return name;
	}
}
