/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.Outlet;
import com.floreantpos.model.ProductType;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

public class LabTestReportModel extends ListTableModel<TicketItem> {
	private boolean showQuantityWithItemName = true;

	public LabTestReportModel() {
		super(new String[] { "itemName", "qty", "itemSubtotalAmount", "testCategoryName", "productType", "labTestRoomNo", "unit", "itemDiscount", //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$//$NON-NLS-7$//$NON-NLS-8$
				"ItemDiscountName" }); //$NON-NLS-1$
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		TicketItem labTestItem = (TicketItem) rows.get(rowIndex);
		ProductType productType = ProductType.fromString(labTestItem.getProductType());

		switch (columnIndex) {
			case 0:
				//if (StringUtils.isNotBlank(labTestItem.getCategoryName()) || ProductType.match(labTestItem.getProductType(), ProductType.GOODS)) {
				//	return "  " + labTestItem.getNameDisplay(); //$NON-NLS-1$
				//}/
				//else {
				if (showQuantityWithItemName) {					
					return labTestItem.getNameDisplay();
				}
				return labTestItem.getNameDisplay(labTestItem.getName(), false, true, false);
			//}

			case 1:
				return labTestItem.getQuantity().intValue();

			case 2:
				return labTestItem.getSubtotalAmount();

			case 3:

				return StringUtils.isNotBlank(labTestItem.getCategoryName()) ? labTestItem.getCategoryName() : "";

			case 4:
				Outlet outlet = DataProvider.get().getOutlet();
				if (ProductType.match(labTestItem.getProductType(), ProductType.PATHOLOGY)
						|| ProductType.match(labTestItem.getProductType(), ProductType.SERVICES)) {
					return ""; //$NON-NLS-1$
				}
				if (ProductType.match(labTestItem.getProductType(), ProductType.GOODS)) {
					if (outlet.isShowGroupLabTestByCategory() && StringUtils.isNotBlank(labTestItem.getCategoryName())) {
						return ""; //$NON-NLS-1$
					}
					else {
						return "Consumable products"; //$NON-NLS-1$
					}
				}
				return (productType.getDisplayString());

			case 5:
				return StringUtils.isBlank(labTestItem.getLabTestRoomNo()) ? null : labTestItem.getLabTestRoomNo().trim();

			case 6:
				return labTestItem.getUnitNameDisplay();

			case 7:
				Double discountAmount = labTestItem.getDiscountAmount();
				if (NumberUtil.isZero(discountAmount)) {
					return null;
				}
				return (-1) * discountAmount;

			case 8:
				List<TicketItemDiscount> discounts = labTestItem.getDiscounts();
				return discounts != null && !discounts.isEmpty() ? discounts.get(0).getName() : StringUtils.EMPTY;

		}
		return null;
	}

	public void setShowQuantityWithItemName(boolean b) {
		this.showQuantityWithItemName  = b;
		
	}
}
