package com.floreantpos.report.model;

import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.floreantpos.POSConstants;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;

public class PaymentReceivedReportData {
	public static String PROP_TICKET_ID = "ticketId"; //$NON-NLS-1$
	public static String PROP_TICKET = "ticket"; //$NON-NLS-1$

	private String paymentTypeString;
	private String customPaymentName;
	private String outletId;
	private String userId;
	private String id;
	private String transactionType;
	private Date transactionTime;
	private Double amount;
	private String ticketId;
	private Ticket ticket;

	private Date orderDate;

	public PaymentReceivedReportData() {
	}

	public String getPaymentTypeString() {
		return paymentTypeString;
	}

	public String getPaymentTypeStringDisplay() {
		PaymentType paymentType = null;
		try {
			paymentType = PaymentType.valueOf(paymentTypeString);
		} catch (Exception e) {
			paymentType = PaymentType.fromDisplayString(paymentTypeString);
		}

		if (paymentType == null) {
			return "";
		}
		String paymentTypeStr;
		if (paymentType.equals(PaymentType.CUSTOM_PAYMENT)) {
			String customPaymentName = getCustomPaymentName();
			paymentTypeStr = StringUtils.isEmpty(customPaymentName) ? null : customPaymentName;
		}
		else {
			paymentTypeStr = paymentType.getDisplayString();
		}

		return paymentTypeStr;
	}

	public void setPaymentTypeString(String paymentTypeString) {
		this.paymentTypeString = paymentTypeString;
	}

	public String getCustomPaymentName() {
		return customPaymentName;
	}

	public void setCustomPaymentName(String customPaymentName) {
		this.customPaymentName = customPaymentName;
	}

	public String getOutletId() {
		return outletId;
	}

	public void setOutletId(String outletId) {
		this.outletId = outletId;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getUserDisplay() {
		User user = DataProvider.get().getUserById(getUserId(), getOutletId());
		if (user == null) {
			return POSConstants.NONE;
		}
		return user.getFullName();
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public Date getTransactionTime() {
		return transactionTime;
	}

	public void setTransactionTime(Date transactionTime) {
		this.transactionTime = transactionTime;
	}

	public String getTransactionTimeDisplay() {
		return DateUtil.formatDateWithBrowserTimeOffset(getTransactionTime());
	}

	public String getOrderDateDisplay() {
		if (orderDate == null) {
			orderDate = getOrderDate();
		}
		return DateUtil.formatDateWithBrowserTimeOffset(orderDate);
	}

	public void setOrderDate(Date orderDate) {
		this.orderDate = orderDate;
	}

	public Date getOrderDate() {
		return orderDate = getTicket().getCreateDate();
	}

	public Double getAmount() {
		if (getTransactionType().equalsIgnoreCase(TransactionType.DEBIT.name())) {
			return NumberUtil.round((-1) * amount);
		}
		return amount;
	}

	public void setAmount(Double amount) {
		this.amount = amount;
	}

	public String getAmountDisplay() {
		return NumberUtil.formatAmount(NumberUtil.round(getAmount()));

	}

	public String getTransactionType() {
		return transactionType;
	}

	public void setTransactionType(String transactionType) {
		this.transactionType = transactionType;
	}

	public String getTicketId() {
		return ticket.getId();
	}

	public Ticket getTicket() {
		return ticket;
	}

	public void setTicket(Ticket ticket) {
		this.ticket = ticket;
	}

}
