package com.floreantpos.util;

import java.util.Date;

import org.hibernate.Session;

import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.TicketItemDAO;

public class LabTestIdGenerator {

	public static String generateLabTestId() {
		try (Session session = GenericDAO.getInstance().createNewSession()) {
			String date = SequenceNumber.yearMonthDayFormat.format(new Date());
			
			String labTestId = date + SequenceNumber.threeDigitDecimalFormat.format(SequenceNumberDAO.getInstance().getNextSequenceNumber(SequenceNumber.LAB_TEST_SEQUENCE_NUMBER, date));
			while (TicketItemDAO.getInstance().findByLabTest(labTestId, session) != null) {
				labTestId = date + SequenceNumber.threeDigitDecimalFormat.format(SequenceNumberDAO.getInstance().getNextSequenceNumber(SequenceNumber.LAB_TEST_SEQUENCE_NUMBER, date));
			}
			
			return labTestId;
		}
	}
}
