package com.orocube.rest.service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;

public class JsonBeanFieldExcluder implements ExclusionStrategy {

	private Class<?> c;
	private String[] fieldNames;
	private List<Class> classes = new ArrayList<Class>();

	public JsonBeanFieldExcluder(Class... clazz) throws SecurityException, NoSuchFieldException, ClassNotFoundException {
		for (Class class1 : clazz) {
			classes.add(class1);
		}
	}

	public boolean shouldSkipClass(Class<?> arg0) {
		if (classes != null && classes.contains(arg0))
			return true;

		return c == arg0;
	}

	public boolean shouldSkipField(FieldAttributes f) {
		String fieldName = f.getName();
		Class<?> theClass = f.getDeclaringClass();
		boolean duplicateProp = isFieldInSuperclass(theClass, fieldName);
		if (shouldSkipClass(f.getDeclaredClass()) || duplicateProp)
			return true;
		return (f.getDeclaringClass() == c || (fieldNames != null && escapeField(f.getName())));
	}

	private boolean isFieldInSuperclass(Class<?> subclass, String fieldName) {
		if(fieldName.equals("hashCode")) //$NON-NLS-1$
			return true;
		/*Class<?> superclass = subclass.getSuperclass();
		Field field;

		while (superclass != null) {
			field = getField(superclass, fieldName);

			if (field != null)
				return true;

			superclass = superclass.getSuperclass();
		}*/
		return false;
	}

	private Field getField(Class<?> theClass, String fieldName) {
		try {
			return theClass.getDeclaredField(fieldName);
		} catch (Exception e) {
			return null;
		}
	}

	private boolean escapeField(String f) {
		if (f.equals("hashCode")) //$NON-NLS-1$
			return true;
		for (String fieldName : fieldNames) {
			if (f.equals(fieldName))
				return true;
		}
		return false;
	}

}
