package com.orocube.rest.service.mqtt;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;

import com.floreantpos.PosLog;
import com.floreantpos.model.util.MqttCommand;

public abstract class OroMqttMessageReceiver implements IMqttMessageListener {
	private final Set<OroMqttDataListener> dataListeners = new HashSet<>();
	private OroMqttDataListener medlogicsDataListener;

	@Override
	public void messageArrived(String topic, MqttMessage message) throws Exception {
		AsyncAction.execute(() -> {
			try {
				handleMessage(topic, message);
			} catch (Exception e) {
				PosLog.error(getClass(), e);
			}
		});
	}

	private void handleMessage(String topic, MqttMessage message) throws Exception {
		PosLog.debug(getClass(), "Notification received: "); //$NON-NLS-1$
		if (topic.endsWith(MqttCommand.TOPIC_MEDLOGICS_DATA) || topic.endsWith(MqttCommand.TOPIC_MEDLOGICS_NOTIFICATION)) {
			if (medlogicsDataListener == null) {
				return;
			}
			medlogicsDataListener.mqttCommandReceived(topic, message);
		}
		else {
			for (OroMqttDataListener oroMqttDataListener : dataListeners) {
				oroMqttDataListener.mqttCommandReceived(topic, message);
			}
		}
	}

	public void addDataListener(OroMqttDataListener dataListener) {
		if (dataListener != null && !dataListeners.contains(dataListener)) {
			dataListeners.add(dataListener);
		}
	}

	public void removeDataListener(OroMqttDataListener dataListener) {
		AsyncAction.execute(() -> dataListeners.remove(dataListener));
	}

	public void setMedlogicsDataListener(OroMqttDataListener medlogicsDataListener) {
		this.medlogicsDataListener = medlogicsDataListener;
	}

}
