/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum BalanceSubType {
	//@formatter:off
	ADD_BALANCE("Add balance"),
	EXPENSE("Expense"),
	TRANSFER_OUT("Transfer out"),
	TRANSFER_IN("Transfer in"),
	BEGIN_CASH_DEPOSIT("Begin cash deposit"),
	WITHDRAW("Withdraw")
	;
	//@formatter:on

	private String displayString;

	private BalanceSubType(String display) {
		this.displayString = display;
	}

	@Override
	public String toString() {
		return displayString;
	}

	public String getDisplayString() {
		return displayString;
	}

	public void setDisplayString(String displayString) {
		this.displayString = displayString;
	}

	public static BalanceSubType fromString(String s) {
		if (StringUtils.isEmpty(s)) {
			return null;
		}

		try {
			BalanceSubType filter = valueOf(s);
			return filter;
		} catch (Exception e) {
			return null;
		}
	}

	public static boolean match(String srcProductTypeName, BalanceSubType trgProductType) {
		BalanceSubType srcProductType = BalanceSubType.fromString(srcProductTypeName);
		return trgProductType.equals(srcProductType);
	}

}
